/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.writer;

import java.io.IOException;
import org.apache.flink.connector.file.sink.utils.FileSinkTestUtils;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketState;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketStateSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.junit.Assert;
import org.junit.Test;

public class FileWriterBucketStateSerializerTest {
    @Test
    public void testWithoutInProgressFile() throws IOException {
        FileWriterBucketState bucketState = new FileWriterBucketState("bucketId", new Path("file:///tmp/bucketId"), 1429537268L, null);
        FileWriterBucketState deserialized = this.serializeAndDeserialize(bucketState);
        this.assertBucketStateEquals(bucketState, deserialized);
    }

    @Test
    public void testWithInProgressFile() throws IOException {
        FileWriterBucketState bucketState = new FileWriterBucketState("bucketId", new Path("file:///tmp/bucketId"), 1429537268L, (InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable());
        FileWriterBucketState deserialized = this.serializeAndDeserialize(bucketState);
        this.assertBucketStateEquals(bucketState, deserialized);
    }

    private void assertBucketStateEquals(FileWriterBucketState bucketState, FileWriterBucketState deserialized) {
        Assert.assertEquals((Object)bucketState.getBucketId(), (Object)deserialized.getBucketId());
        Assert.assertEquals((Object)bucketState.getBucketPath(), (Object)deserialized.getBucketPath());
        Assert.assertEquals((long)bucketState.getInProgressFileCreationTime(), (long)deserialized.getInProgressFileCreationTime());
        Assert.assertEquals((Object)bucketState.getInProgressFileRecoverable(), (Object)deserialized.getInProgressFileRecoverable());
    }

    private FileWriterBucketState serializeAndDeserialize(FileWriterBucketState bucketState) throws IOException {
        FileWriterBucketStateSerializer serializer = new FileWriterBucketStateSerializer(new FileSinkTestUtils.SimpleVersionedWrapperSerializer<InProgressFileWriter.InProgressFileRecoverable>(FileSinkTestUtils.TestInProgressFileRecoverable::new), new FileSinkTestUtils.SimpleVersionedWrapperSerializer<InProgressFileWriter.PendingFileRecoverable>(FileSinkTestUtils.TestPendingFileRecoverable::new));
        byte[] data = serializer.serialize(bucketState);
        return serializer.deserialize(serializer.getVersion(), data);
    }
}

