/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.utils;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.junit.Assert;

public class IntegerFileSinkTestDataUtils {
    public static void checkIntegerSequenceSinkOutput(String path, int numRecords, int numBuckets, int numSources) throws Exception {
        File dir = new File(path);
        String[] subDirNames = dir.list();
        Assert.assertNotNull((Object)subDirNames);
        Arrays.sort(subDirNames, Comparator.comparingInt(Integer::parseInt));
        Assert.assertEquals((long)numBuckets, (long)subDirNames.length);
        for (int i = 0; i < numBuckets; ++i) {
            Assert.assertEquals((Object)Integer.toString(i), (Object)subDirNames[i]);
            File bucketDir = new File(path, subDirNames[i]);
            Assert.assertTrue((String)(bucketDir.getAbsolutePath() + " Should be a existing directory"), (boolean)bucketDir.isDirectory());
            HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
            File[] files = bucketDir.listFiles(f -> !f.getName().startsWith("."));
            Assert.assertNotNull((Object)files);
            for (File file : files) {
                Assert.assertTrue((boolean)file.isFile());
                try {
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                    Throwable throwable = null;
                    try {
                        try {
                            while (true) {
                                int value = dataInputStream.readInt();
                                counts.compute(value, (k, v) -> v == null ? 1 : v + 1);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (dataInputStream != null) {
                            if (throwable != null) {
                                try {
                                    dataInputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                dataInputStream.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (EOFException eOFException) {
                }
            }
            int expectedCount = numRecords / numBuckets + (i < numRecords % numBuckets ? 1 : 0);
            Assert.assertEquals((long)expectedCount, (long)counts.size());
            for (int j = i; j < numRecords; j += numBuckets) {
                Assert.assertEquals((String)("The record " + j + " should occur " + numSources + " times,  but only occurs " + counts.getOrDefault(j, 0) + "time"), (long)numSources, (long)counts.getOrDefault(j, 0).intValue());
            }
        }
    }

    public static class ModuloBucketAssigner
    implements BucketAssigner<Integer, String> {
        private final int numBuckets;

        public ModuloBucketAssigner(int numBuckets) {
            this.numBuckets = numBuckets;
        }

        public String getBucketId(Integer element, BucketAssigner.Context context) {
            return Integer.toString(element % this.numBuckets);
        }

        public SimpleVersionedSerializer<String> getSerializer() {
            return SimpleVersionedStringSerializer.INSTANCE;
        }
    }

    public static class IntEncoder
    implements Encoder<Integer> {
        public void encode(Integer element, OutputStream stream) throws IOException {
            stream.write(ByteBuffer.allocate(4).putInt(element).array());
            stream.flush();
        }
    }
}

