/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.committer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.committer.FileCommitter;
import org.apache.flink.connector.file.sink.utils.FileSinkTestUtils;
import org.apache.flink.connector.file.sink.utils.NoOpBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.junit.Assert;
import org.junit.Test;

public class FileCommitterTest {
    @Test
    public void testCommitPendingFile() throws Exception {
        StubBucketWriter stubBucketWriter = new StubBucketWriter();
        FileCommitter fileCommitter = new FileCommitter((BucketWriter)stubBucketWriter);
        FileSinkCommittable fileSinkCommittable = new FileSinkCommittable((InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable());
        List toRetry = fileCommitter.commit(Collections.singletonList(fileSinkCommittable));
        Assert.assertEquals((long)1L, (long)stubBucketWriter.getRecoveredPendingFiles().size());
        Assert.assertEquals((long)0L, (long)stubBucketWriter.getNumCleanUp());
        Assert.assertTrue((boolean)stubBucketWriter.getRecoveredPendingFiles().get(0).isCommitted());
        Assert.assertEquals((long)0L, (long)toRetry.size());
    }

    @Test
    public void testCleanupInProgressFiles() throws Exception {
        StubBucketWriter stubBucketWriter = new StubBucketWriter();
        FileCommitter fileCommitter = new FileCommitter((BucketWriter)stubBucketWriter);
        FileSinkCommittable fileSinkCommittable = new FileSinkCommittable((InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable());
        List toRetry = fileCommitter.commit(Collections.singletonList(fileSinkCommittable));
        Assert.assertEquals((long)0L, (long)stubBucketWriter.getRecoveredPendingFiles().size());
        Assert.assertEquals((long)1L, (long)stubBucketWriter.getNumCleanUp());
        Assert.assertEquals((long)0L, (long)toRetry.size());
    }

    @Test
    public void testCommitMultiple() throws Exception {
        StubBucketWriter stubBucketWriter = new StubBucketWriter();
        FileCommitter fileCommitter = new FileCommitter((BucketWriter)stubBucketWriter);
        List<FileSinkCommittable> committables = Arrays.asList(new FileSinkCommittable((InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable()), new FileSinkCommittable((InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable()), new FileSinkCommittable((InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable()), new FileSinkCommittable((InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable()), new FileSinkCommittable((InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable()));
        List toRetry = fileCommitter.commit(committables);
        Assert.assertEquals((long)3L, (long)stubBucketWriter.getRecoveredPendingFiles().size());
        Assert.assertEquals((long)2L, (long)stubBucketWriter.getNumCleanUp());
        stubBucketWriter.getRecoveredPendingFiles().forEach(pendingFile -> Assert.assertTrue((boolean)pendingFile.isCommitted()));
        Assert.assertEquals((long)0L, (long)toRetry.size());
    }

    private static class StubBucketWriter
    extends NoOpBucketWriter {
        private final List<RecordingPendingFile> recoveredPendingFiles = new ArrayList<RecordingPendingFile>();
        private int numCleanUp;

        private StubBucketWriter() {
        }

        @Override
        public BucketWriter.PendingFile recoverPendingFile(InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable) throws IOException {
            RecordingPendingFile pendingFile = new RecordingPendingFile();
            this.recoveredPendingFiles.add(pendingFile);
            return pendingFile;
        }

        @Override
        public boolean cleanupInProgressFileRecoverable(InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable) throws IOException {
            ++this.numCleanUp;
            return true;
        }

        public List<RecordingPendingFile> getRecoveredPendingFiles() {
            return this.recoveredPendingFiles;
        }

        public int getNumCleanUp() {
            return this.numCleanUp;
        }
    }

    private static class RecordingPendingFile
    implements BucketWriter.PendingFile {
        private boolean committed;

        private RecordingPendingFile() {
        }

        public void commit() throws IOException {
            this.commitAfterRecovery();
        }

        public void commitAfterRecovery() throws IOException {
            this.committed = true;
        }

        public boolean isCommitted() {
            return this.committed;
        }
    }
}

