/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.sink.utils.IntegerFileSinkTestDataUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.PartFileInfo;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.CheckpointRollingPolicy;
import org.apache.flink.util.TestLogger;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public abstract class FileSinkITBase
extends TestLogger {
    protected static final int NUM_SOURCES = 4;
    protected static final int NUM_SINKS = 3;
    protected static final int NUM_RECORDS = 10000;
    protected static final int NUM_BUCKETS = 4;
    protected static final double FAILOVER_RATIO = 0.4;
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    @Parameterized.Parameter
    public boolean triggerFailover;

    @Parameterized.Parameters(name="triggerFailover = {0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({false}, {true});
    }

    @Test
    public void testFileSink() throws Exception {
        String path = TEMPORARY_FOLDER.newFolder().getAbsolutePath();
        JobGraph jobGraph = this.createJobGraph(path);
        Configuration config = new Configuration();
        config.setString(RestOptions.BIND_PORT, "18081-19000");
        MiniClusterConfiguration cfg = new MiniClusterConfiguration.Builder().setNumTaskManagers(1).setNumSlotsPerTaskManager(4).setConfiguration(config).build();
        try (MiniCluster miniCluster = new MiniCluster(cfg);){
            miniCluster.start();
            miniCluster.executeJobBlocking(jobGraph);
        }
        IntegerFileSinkTestDataUtils.checkIntegerSequenceSinkOutput(path, 10000, 4, 4);
    }

    protected abstract JobGraph createJobGraph(String var1);

    protected FileSink<Integer> createFileSink(String path) {
        return ((FileSink.DefaultRowFormatBuilder)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(path), (Encoder)new IntegerFileSinkTestDataUtils.IntEncoder()).withBucketAssigner((BucketAssigner)new IntegerFileSinkTestDataUtils.ModuloBucketAssigner(4))).withRollingPolicy((RollingPolicy)new PartSizeAndCheckpointRollingPolicy(1024L))).build();
    }

    private static class PartSizeAndCheckpointRollingPolicy
    extends CheckpointRollingPolicy<Integer, String> {
        private final long maxPartSize;

        public PartSizeAndCheckpointRollingPolicy(long maxPartSize) {
            this.maxPartSize = maxPartSize;
        }

        public boolean shouldRollOnEvent(PartFileInfo<String> partFileState, Integer element) throws IOException {
            return partFileState.getSize() >= this.maxPartSize;
        }

        public boolean shouldRollOnProcessingTime(PartFileInfo<String> partFileState, long currentTime) {
            return false;
        }
    }
}

