/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.io.IOException;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.FileSinkCommittableSerializer;
import org.apache.flink.connector.file.sink.utils.FileSinkTestUtils;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileCommittableSerializerTest {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @Test
    public void testCommittableWithPendingFile() throws IOException {
        FileSinkCommittable committable = new FileSinkCommittable((InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable());
        FileSinkCommittable deserialized = this.serializeAndDeserialize(committable);
        Assert.assertEquals((Object)committable.getPendingFile(), (Object)deserialized.getPendingFile());
        Assert.assertEquals((Object)committable.getInProgressFileToCleanup(), (Object)deserialized.getInProgressFileToCleanup());
    }

    @Test
    public void testCommittableWithInProgressFileToCleanup() throws IOException {
        FileSinkCommittable committable = new FileSinkCommittable((InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable());
        FileSinkCommittable deserialized = this.serializeAndDeserialize(committable);
        Assert.assertEquals((Object)committable.getPendingFile(), (Object)deserialized.getPendingFile());
        Assert.assertEquals((Object)committable.getInProgressFileToCleanup(), (Object)deserialized.getInProgressFileToCleanup());
    }

    private FileSinkCommittable serializeAndDeserialize(FileSinkCommittable committable) throws IOException {
        FileSinkCommittableSerializer serializer = new FileSinkCommittableSerializer(new FileSinkTestUtils.SimpleVersionedWrapperSerializer<InProgressFileWriter.PendingFileRecoverable>(FileSinkTestUtils.TestPendingFileRecoverable::new), new FileSinkTestUtils.SimpleVersionedWrapperSerializer<InProgressFileWriter.InProgressFileRecoverable>(FileSinkTestUtils.TestInProgressFileRecoverable::new));
        byte[] data = serializer.serialize(committable);
        return serializer.deserialize(serializer.getVersion(), data);
    }
}

