/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.pattern.conditions;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.RichIterativeCondition;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

public abstract class RichCompositeIterativeCondition<T>
extends RichIterativeCondition<T> {
    private static final long serialVersionUID = 1L;
    private final IterativeCondition<T>[] nestedConditions;

    @SafeVarargs
    public RichCompositeIterativeCondition(IterativeCondition<T> ... nestedConditions) {
        for (IterativeCondition<T> condition : nestedConditions) {
            Preconditions.checkNotNull(condition, (String)"The condition cannot be null.");
        }
        this.nestedConditions = nestedConditions;
    }

    public IterativeCondition<T>[] getNestedConditions() {
        return this.nestedConditions;
    }

    @Override
    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        for (IterativeCondition<T> nestedCondition : this.nestedConditions) {
            FunctionUtils.setFunctionRuntimeContext(nestedCondition, (RuntimeContext)t);
        }
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        for (IterativeCondition<T> nestedCondition : this.nestedConditions) {
            FunctionUtils.openFunction(nestedCondition, (Configuration)parameters);
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        for (IterativeCondition<T> nestedCondition : this.nestedConditions) {
            FunctionUtils.closeFunction(nestedCondition);
        }
    }
}

