/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.LegacySerializerSnapshotTransformer;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.cep.nfa.sharedbuffer.LockableTypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class Lockable<T> {
    private int refCounter;
    private final T element;

    public Lockable(T element, int refCounter) {
        this.refCounter = refCounter;
        this.element = element;
    }

    public void lock() {
        ++this.refCounter;
    }

    boolean release() {
        if (this.refCounter <= 0) {
            return true;
        }
        --this.refCounter;
        return this.refCounter == 0;
    }

    public T getElement() {
        return this.element;
    }

    public String toString() {
        return "Lock{refCounter=" + this.refCounter + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lockable lockable = (Lockable)o;
        return this.refCounter == lockable.refCounter && Objects.equals(this.element, lockable.element);
    }

    public int hashCode() {
        return Objects.hash(this.refCounter, this.element);
    }

    public static class LockableTypeSerializer<E>
    extends TypeSerializer<Lockable<E>>
    implements LegacySerializerSnapshotTransformer<Lockable<E>> {
        private static final long serialVersionUID = 3298801058463337340L;
        private final TypeSerializer<E> elementSerializer;

        LockableTypeSerializer(TypeSerializer<E> elementSerializer) {
            this.elementSerializer = elementSerializer;
        }

        public boolean isImmutableType() {
            return false;
        }

        public LockableTypeSerializer<E> duplicate() {
            TypeSerializer elementSerializerCopy = this.elementSerializer.duplicate();
            return elementSerializerCopy == this.elementSerializer ? this : new LockableTypeSerializer<E>(elementSerializerCopy);
        }

        public Lockable<E> createInstance() {
            return null;
        }

        public Lockable<E> copy(Lockable<E> from) {
            return new Lockable<Object>(this.elementSerializer.copy(((Lockable)from).element), ((Lockable)from).refCounter);
        }

        public Lockable<E> copy(Lockable<E> from, Lockable<E> reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(Lockable<E> record, DataOutputView target) throws IOException {
            IntSerializer.INSTANCE.serialize(Integer.valueOf(((Lockable)record).refCounter), target);
            this.elementSerializer.serialize(((Lockable)record).element, target);
        }

        public Lockable<E> deserialize(DataInputView source) throws IOException {
            int refCount = IntSerializer.INSTANCE.deserialize(source);
            Object record = this.elementSerializer.deserialize(source);
            return new Lockable<Object>(record, refCount);
        }

        public Lockable<E> deserialize(Lockable<E> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            IntSerializer.INSTANCE.copy(source, target);
            Object element = this.elementSerializer.deserialize(source);
            this.elementSerializer.serialize(element, target);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            LockableTypeSerializer that = (LockableTypeSerializer)((Object)o);
            return Objects.equals(this.elementSerializer, that.elementSerializer);
        }

        public int hashCode() {
            return Objects.hash(this.elementSerializer);
        }

        public TypeSerializerSnapshot<Lockable<E>> snapshotConfiguration() {
            return new LockableTypeSerializerSnapshot(this);
        }

        @VisibleForTesting
        TypeSerializer<E> getElementSerializer() {
            return this.elementSerializer;
        }

        public <U> TypeSerializerSnapshot<Lockable<E>> transformLegacySerializerSnapshot(TypeSerializerSnapshot<U> legacySnapshot) {
            if (legacySnapshot instanceof LockableTypeSerializerSnapshot) {
                return legacySnapshot;
            }
            if (legacySnapshot instanceof TypeSerializerConfigSnapshot) {
                LockableTypeSerializer.setElementSerializerAsPriorSerializer(legacySnapshot, this.elementSerializer);
            }
            LockableTypeSerializerSnapshot lockableSnapshot = new LockableTypeSerializerSnapshot();
            CompositeTypeSerializerUtil.setNestedSerializersSnapshots(lockableSnapshot, (TypeSerializerSnapshot[])new TypeSerializerSnapshot[]{legacySnapshot});
            return lockableSnapshot;
        }

        private static <U, E> void setElementSerializerAsPriorSerializer(TypeSerializerSnapshot<U> legacySnapshot, TypeSerializer<E> elementSerializer) {
            TypeSerializerConfigSnapshot elementLegacySnapshot = (TypeSerializerConfigSnapshot)legacySnapshot;
            elementLegacySnapshot.setPriorSerializer(elementSerializer);
        }
    }
}

