/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.api.avro.FSDataInputStreamWrapper;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroInputFormat<E>
extends FileInputFormat<E>
implements ResultTypeQueryable<E> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AvroInputFormat.class);
    private final Class<E> avroValueType;
    private boolean reuseAvroValue = true;
    private transient FileReader<E> dataFileReader;
    private transient long end;

    public AvroInputFormat(Path filePath, Class<E> type) {
        super(filePath);
        this.avroValueType = type;
    }

    public void setReuseAvroValue(boolean reuseAvroValue) {
        this.reuseAvroValue = reuseAvroValue;
    }

    public void setUnsplittable(boolean unsplittable) {
        this.unsplittable = unsplittable;
    }

    public TypeInformation<E> getProducedType() {
        return TypeExtractor.getForClass(this.avroValueType);
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        Object datumReader = SpecificRecordBase.class.isAssignableFrom(this.avroValueType) ? new SpecificDatumReader(this.avroValueType) : new ReflectDatumReader(this.avroValueType);
        LOG.info("Opening split " + split);
        FSDataInputStreamWrapper in = new FSDataInputStreamWrapper(this.stream, split.getPath().getFileSystem().getFileStatus(split.getPath()).getLen());
        this.dataFileReader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
        this.dataFileReader.sync(split.getStart());
        this.end = split.getStart() + split.getLength();
    }

    public boolean reachedEnd() throws IOException {
        return !this.dataFileReader.hasNext() || this.dataFileReader.pastSync(this.end);
    }

    public E nextRecord(E reuseValue) throws IOException {
        if (this.reachedEnd()) {
            return null;
        }
        if (!this.reuseAvroValue) {
            reuseValue = InstantiationUtil.instantiate(this.avroValueType, Object.class);
        }
        reuseValue = this.dataFileReader.next(reuseValue);
        return reuseValue;
    }
}

