/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.openmessaging.api.Message;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RRCallbackResponseHandlerAdapter<ProtocolMessage>
implements ResponseHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(RRCallbackResponseHandlerAdapter.class);
    private final long createTime;
    private final ProtocolMessage protocolMessage;
    private final RRCallback<ProtocolMessage> rrCallback;
    private final long timeout;

    public RRCallbackResponseHandlerAdapter(ProtocolMessage protocolMessage, RRCallback<ProtocolMessage> rrCallback, long timeout) {
        Preconditions.checkNotNull(rrCallback, (Object)"rrCallback invalid");
        Preconditions.checkNotNull(protocolMessage, (Object)"message invalid");
        if (!(protocolMessage instanceof EventMeshMessage || protocolMessage instanceof CloudEvent || protocolMessage instanceof Message)) {
            throw new IllegalArgumentException(String.format("ProtocolMessage: %s is not supported", protocolMessage));
        }
        this.protocolMessage = protocolMessage;
        this.rrCallback = rrCallback;
        this.timeout = timeout;
        this.createTime = System.currentTimeMillis();
    }

    public String handleResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            this.rrCallback.onException((Throwable)new EventMeshException(response.toString()));
            return response.toString();
        }
        if (System.currentTimeMillis() - this.createTime > this.timeout) {
            String err = String.format("response too late, message: %s", this.protocolMessage);
            this.rrCallback.onException((Throwable)new EventMeshException(err));
            return err;
        }
        String res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
        EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)res, EventMeshRetObj.class);
        if (ret.getRetCode() != EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
            this.rrCallback.onException((Throwable)new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg()));
            return res;
        }
        ProtocolMessage protocolMessage = this.transformToProtocolMessage(ret);
        this.rrCallback.onSuccess(protocolMessage);
        return protocolMessage.toString();
    }

    private ProtocolMessage transformToProtocolMessage(EventMeshRetObj ret) {
        SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JsonUtils.deserialize((String)ret.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
        if (this.protocolMessage instanceof EventMeshMessage) {
            EventMeshMessage eventMeshMessage = EventMeshMessage.builder().content(replyMessage.body).prop(replyMessage.properties).topic(replyMessage.topic).build();
            return (ProtocolMessage)eventMeshMessage;
        }
        throw new RuntimeException("Unsupported callback message type");
    }
}

