/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.google.common.base.Preconditions;
import io.cloudevents.SpecVersion;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import org.apache.eventmesh.client.http.AbstractHttpClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.client.http.producer.EventMeshProtocolProducer;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.client.http.producer.RRCallbackResponseHandlerAdapter;
import org.apache.eventmesh.client.http.util.HttpUtils;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventMeshMessageProducer
extends AbstractHttpClient
implements EventMeshProtocolProducer<EventMeshMessage> {
    private static final Logger log = LoggerFactory.getLogger(EventMeshMessageProducer.class);

    public EventMeshMessageProducer(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        super(eventMeshHttpClientConfig);
    }

    @Override
    public void publish(EventMeshMessage message) throws EventMeshException {
        this.validateEventMeshMessage(message);
        RequestParam requestParam = this.buildCommonPostParam(message).addHeader("code", RequestCode.MSG_SEND_ASYNC.getRequestCode());
        String target = this.selectEventMesh();
        try {
            String response = HttpUtils.post(this.httpClient, target, requestParam);
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)response, EventMeshRetObj.class);
            if (ret.getRetCode() != EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
            }
        }
        catch (Exception exception) {
            throw new EventMeshException(String.format("Publish message error, target:%s", target), (Throwable)exception);
        }
    }

    @Override
    public EventMeshMessage request(EventMeshMessage message, long timeout) throws EventMeshException {
        this.validateEventMeshMessage(message);
        RequestParam requestParam = this.buildCommonPostParam(message).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
        String target = this.selectEventMesh();
        try {
            String response = HttpUtils.post(this.httpClient, target, requestParam);
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)response, EventMeshRetObj.class);
            if (ret.getRetCode() == EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                return this.transformMessage(ret);
            }
            throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
        }
        catch (Exception e) {
            throw new EventMeshException(String.format("Request message error, target:%s", target), (Throwable)e);
        }
    }

    @Override
    public void request(EventMeshMessage message, RRCallback<EventMeshMessage> rrCallback, long timeout) throws EventMeshException {
        this.validateEventMeshMessage(message);
        RequestParam requestParam = this.buildCommonPostParam(message).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
        String target = this.selectEventMesh();
        RRCallbackResponseHandlerAdapter<EventMeshMessage> adapter = new RRCallbackResponseHandlerAdapter<EventMeshMessage>(message, rrCallback, timeout);
        try {
            HttpUtils.post(this.httpClient, null, target, requestParam, adapter);
        }
        catch (IOException e) {
            throw new EventMeshException(String.format("Request message error, target:%s", target), (Throwable)e);
        }
    }

    private void validateEventMeshMessage(EventMeshMessage message) {
        Preconditions.checkNotNull((Object)message, (Object)"eventMeshMessage invalid");
        Preconditions.checkNotNull((Object)message.getTopic(), (Object)"eventMeshMessage[topic] invalid");
        Preconditions.checkNotNull((Object)message.getContent(), (Object)"eventMeshMessage[content] invalid");
    }

    private RequestParam buildCommonPostParam(EventMeshMessage message) {
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("env", this.eventMeshHttpClientConfig.getEnv()).addHeader("idc", this.eventMeshHttpClientConfig.getIdc()).addHeader("ip", this.eventMeshHttpClientConfig.getIp()).addHeader("pid", this.eventMeshHttpClientConfig.getPid()).addHeader("sys", this.eventMeshHttpClientConfig.getSys()).addHeader("username", this.eventMeshHttpClientConfig.getUserName()).addHeader("passwd", this.eventMeshHttpClientConfig.getPassword()).addHeader("version", ProtocolVersion.V1.getVersion()).addHeader("protocoltype", "eventmeshmessage").addHeader("protocoldesc", "http").addHeader("protocolversion", SpecVersion.V1.toString()).addHeader("language", "JAVA").addBody("producergroup", this.eventMeshHttpClientConfig.getProducerGroup()).addBody("topic", message.getTopic()).addBody("content", message.getContent()).addBody("ttl", message.getProp("ttl")).addBody("bizseqno", message.getBizSeqNo()).addBody("uniqueid", message.getUniqueId());
        return requestParam;
    }

    private EventMeshMessage transformMessage(EventMeshRetObj retObj) {
        SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JsonUtils.deserialize((String)retObj.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
        return EventMeshMessage.builder().content(replyMessage.body).prop(replyMessage.properties).topic(replyMessage.topic).build();
    }
}

