/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.util;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.provider.EventFormatProvider;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(EventMeshClientUtil.class);

    public static RequestHeader buildHeader(EventMeshGrpcClientConfig clientConfig, String protocolType) {
        return RequestHeader.newBuilder().setEnv(clientConfig.getEnv()).setIdc(clientConfig.getIdc()).setIp(IPUtils.getLocalAddress()).setPid(Long.toString(ThreadUtils.getPID())).setSys(clientConfig.getSys()).setLanguage(clientConfig.getLanguage()).setUsername(clientConfig.getUserName()).setPassword(clientConfig.getPassword()).setProtocolType(protocolType).setProtocolDesc("grpc").setProtocolVersion(SpecVersion.V1.toString()).build();
    }

    public static <T> T buildMessage(SimpleMessage message, String protocolType) {
        String seq = message.getSeqNum();
        String uniqueId = message.getUniqueId();
        String content = message.getContent();
        if (StringUtils.isEmpty((CharSequence)seq) && StringUtils.isEmpty((CharSequence)uniqueId)) {
            HashMap response = (HashMap)JsonUtils.deserialize((String)content, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            return (T)response;
        }
        if ("cloudevents".equals(protocolType)) {
            String contentType = message.getPropertiesOrDefault("contenttype", "application/cloudevents+json");
            try {
                CloudEvent cloudEvent = EventFormatProvider.getInstance().resolveFormat(contentType).deserialize(content.getBytes(StandardCharsets.UTF_8));
                CloudEventBuilder cloudEventBuilder = CloudEventBuilder.from((CloudEvent)cloudEvent).withSubject(message.getTopic()).withExtension("seqnum", message.getSeqNum()).withExtension("uniqueid", message.getUniqueId());
                message.getPropertiesMap().forEach((arg_0, arg_1) -> ((CloudEventBuilder)cloudEventBuilder).withExtension(arg_0, arg_1));
                return (T)cloudEventBuilder.build();
            }
            catch (Throwable t) {
                logger.warn("Error in building message. {}", (Object)t.getMessage());
                return null;
            }
        }
        EventMeshMessage eventMeshMessage = EventMeshMessage.builder().content(content).topic(message.getTopic()).bizSeqNo(seq).uniqueId(uniqueId).prop(message.getPropertiesMap()).build();
        return (T)eventMeshMessage;
    }

    public static <T> SimpleMessage buildSimpleMessage(T message, EventMeshGrpcClientConfig clientConfig, String protocolType) {
        if ("cloudevents".equals(protocolType)) {
            CloudEvent cloudEvent = (CloudEvent)message;
            String contentType = StringUtils.isEmpty((CharSequence)cloudEvent.getDataContentType()) ? "application/cloudevents+json" : cloudEvent.getDataContentType();
            byte[] bodyByte = EventFormatProvider.getInstance().resolveFormat(contentType).serialize(cloudEvent);
            String content = new String(bodyByte, StandardCharsets.UTF_8);
            String ttl = cloudEvent.getExtension("ttl") == null ? "4000" : cloudEvent.getExtension("ttl").toString();
            String seqNum = cloudEvent.getExtension("seqnum") == null ? RandomStringUtils.generateNum((int)30) : cloudEvent.getExtension("seqnum").toString();
            String uniqueId = cloudEvent.getExtension("uniqueid") == null ? RandomStringUtils.generateNum((int)30) : cloudEvent.getExtension("uniqueid").toString();
            SimpleMessage.Builder builder = SimpleMessage.newBuilder().setHeader(EventMeshClientUtil.buildHeader(clientConfig, protocolType)).setProducerGroup(clientConfig.getProducerGroup()).setTopic(cloudEvent.getSubject()).setTtl(ttl).setSeqNum(seqNum).setUniqueId(uniqueId).setContent(content).putProperties("contenttype", contentType);
            for (String extName : cloudEvent.getExtensionNames()) {
                builder.putProperties(extName, cloudEvent.getExtension(extName).toString());
            }
            return builder.build();
        }
        EventMeshMessage eventMeshMessage = (EventMeshMessage)message;
        String ttl = eventMeshMessage.getProp("ttl") == null ? "4000" : eventMeshMessage.getProp("ttl");
        Map props = eventMeshMessage.getProp() == null ? new HashMap() : eventMeshMessage.getProp();
        String seqNum = eventMeshMessage.getBizSeqNo() == null ? RandomStringUtils.generateNum((int)30) : eventMeshMessage.getBizSeqNo();
        String uniqueId = eventMeshMessage.getUniqueId() == null ? RandomStringUtils.generateNum((int)30) : eventMeshMessage.getUniqueId();
        return SimpleMessage.newBuilder().setHeader(EventMeshClientUtil.buildHeader(clientConfig, protocolType)).setProducerGroup(clientConfig.getProducerGroup()).setTopic(eventMeshMessage.getTopic()).setContent(eventMeshMessage.getContent()).setSeqNum(seqNum).setUniqueId(uniqueId).setTtl(ttl).putAllProperties(props).build();
    }

    public static <T> BatchMessage buildBatchMessages(List<T> messageList, EventMeshGrpcClientConfig clientConfig, String protocolType) {
        if ("cloudevents".equals(protocolType)) {
            List<T> events = messageList;
            BatchMessage.Builder messageBuilder = BatchMessage.newBuilder().setHeader(EventMeshClientUtil.buildHeader(clientConfig, protocolType)).setProducerGroup(clientConfig.getProducerGroup()).setTopic(((CloudEvent)events.get(0)).getSubject());
            for (CloudEvent event : events) {
                String contentType = StringUtils.isEmpty((CharSequence)event.getDataContentType()) ? "application/cloudevents+json" : event.getDataContentType();
                byte[] bodyByte = EventFormatProvider.getInstance().resolveFormat(contentType).serialize(event);
                String content = new String(bodyByte, StandardCharsets.UTF_8);
                String ttl = event.getExtension("ttl") == null ? "4000" : event.getExtension("ttl").toString();
                BatchMessage.MessageItem messageItem = BatchMessage.MessageItem.newBuilder().setContent(content).setTtl(ttl).setSeqNum(event.getExtension("seqnum").toString()).setUniqueId(event.getExtension("uniqueid").toString()).putProperties("contenttype", contentType).build();
                messageBuilder.addMessageItem(messageItem);
            }
            return messageBuilder.build();
        }
        List<T> eventMeshMessages = messageList;
        BatchMessage.Builder messageBuilder = BatchMessage.newBuilder().setHeader(EventMeshClientUtil.buildHeader(clientConfig, protocolType)).setProducerGroup(clientConfig.getProducerGroup()).setTopic(((EventMeshMessage)eventMeshMessages.get(0)).getTopic());
        for (EventMeshMessage message : eventMeshMessages) {
            BatchMessage.MessageItem item = BatchMessage.MessageItem.newBuilder().setContent(message.getContent()).setUniqueId(message.getUniqueId()).setSeqNum(message.getBizSeqNo()).setTtl(Optional.ofNullable(message.getProp("ttl")).orElse("4000")).putAllProperties(message.getProp()).build();
            messageBuilder.addMessageItem(item);
        }
        return messageBuilder.build();
    }
}

