/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.body.message;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.utils.JsonUtils;

public class SendMessageRequestBody
extends Body {
    public static final String TOPIC = "topic";
    public static final String BIZSEQNO = "bizseqno";
    public static final String UNIQUEID = "uniqueid";
    public static final String CONTENT = "content";
    public static final String TTL = "ttl";
    public static final String TAG = "tag";
    public static final String EXTFIELDS = "extFields";
    public static final String PRODUCERGROUP = "producergroup";
    private String topic;
    private String bizSeqNo;
    private String uniqueId;
    private String ttl;
    private String content;
    private String tag;
    private HashMap<String, String> extFields;
    private String producerGroup;

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public void setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public HashMap<String, String> getExtFields() {
        return this.extFields;
    }

    public void setExtFields(HashMap<String, String> extFields) {
        this.extFields = extFields;
    }

    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public static SendMessageRequestBody buildBody(Map<String, Object> bodyParam) {
        SendMessageRequestBody body = new SendMessageRequestBody();
        body.setTopic(MapUtils.getString(bodyParam, (Object)TOPIC));
        body.setBizSeqNo(MapUtils.getString(bodyParam, (Object)BIZSEQNO));
        body.setUniqueId(MapUtils.getString(bodyParam, (Object)UNIQUEID));
        body.setTtl(MapUtils.getString(bodyParam, (Object)TTL));
        body.setTag(MapUtils.getString(bodyParam, (Object)TAG, (String)""));
        body.setContent(MapUtils.getString(bodyParam, (Object)CONTENT));
        String extFields = MapUtils.getString(bodyParam, (Object)EXTFIELDS);
        if (StringUtils.isNotBlank((CharSequence)extFields)) {
            body.setExtFields(JsonUtils.deserialize(extFields, new TypeReference<HashMap<String, String>>(){}));
        }
        body.setProducerGroup(MapUtils.getString(bodyParam, (Object)PRODUCERGROUP));
        return body;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TOPIC, this.topic);
        map.put(BIZSEQNO, this.bizSeqNo);
        map.put(UNIQUEID, this.uniqueId);
        map.put(TTL, this.ttl);
        map.put(TAG, this.tag);
        map.put(CONTENT, this.content);
        map.put(EXTFIELDS, this.extFields);
        map.put(PRODUCERGROUP, this.producerGroup);
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sendMessageRequestBody={").append("topic=").append(this.topic).append(",").append("bizSeqNo=").append(this.bizSeqNo).append(",").append("uniqueId=").append(this.uniqueId).append(",").append("content=").append(this.content).append(",").append("ttl=").append(this.ttl).append(",").append("tag=").append(this.tag).append(",").append("producerGroup=").append(this.producerGroup).append(",").append("extFields=").append(this.extFields).append("}");
        return sb.toString();
    }
}

