/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.body.message;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.utils.JsonUtils;

public class PushMessageRequestBody
extends Body {
    public static final String RANDOMNO = "randomNo";
    public static final String TOPIC = "topic";
    public static final String BIZSEQNO = "bizseqno";
    public static final String UNIQUEID = "uniqueId";
    public static final String CONTENT = "content";
    public static final String EXTFIELDS = "extFields";
    private String randomNo;
    private String topic;
    private String content;
    private String bizSeqNo;
    private String uniqueId;
    private HashMap<String, String> extFields;

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getRandomNo() {
        return this.randomNo;
    }

    public void setRandomNo(String randomNo) {
        this.randomNo = randomNo;
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public void setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public HashMap<String, String> getExtFields() {
        return this.extFields;
    }

    public void setExtFields(HashMap<String, String> extFields) {
        this.extFields = extFields;
    }

    public static PushMessageRequestBody buildBody(Map<String, Object> bodyParam) {
        PushMessageRequestBody pushMessageRequestBody = new PushMessageRequestBody();
        pushMessageRequestBody.setContent(MapUtils.getString(bodyParam, (Object)CONTENT));
        pushMessageRequestBody.setBizSeqNo(MapUtils.getString(bodyParam, (Object)BIZSEQNO));
        pushMessageRequestBody.setTopic(MapUtils.getString(bodyParam, (Object)TOPIC));
        pushMessageRequestBody.setUniqueId(MapUtils.getString(bodyParam, (Object)UNIQUEID));
        pushMessageRequestBody.setRandomNo(MapUtils.getString(bodyParam, (Object)RANDOMNO));
        String extFields = MapUtils.getString(bodyParam, (Object)EXTFIELDS);
        if (StringUtils.isNotBlank((CharSequence)extFields)) {
            pushMessageRequestBody.setExtFields(JsonUtils.deserialize(extFields, new TypeReference<HashMap<String, String>>(){}));
        }
        return pushMessageRequestBody;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RANDOMNO, this.randomNo);
        map.put(TOPIC, this.topic);
        map.put(CONTENT, this.content);
        map.put(BIZSEQNO, this.bizSeqNo);
        map.put(UNIQUEID, this.uniqueId);
        map.put(EXTFIELDS, JsonUtils.serialize(this.extFields));
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("pushMessageRequestBody={").append("randomNo=").append(this.randomNo).append(",").append("topic=").append(this.topic).append(",").append("bizSeqNo=").append(this.bizSeqNo).append(",").append("uniqueId=").append(this.uniqueId).append(",").append("content=").append(this.content).append(",").append("extFields=").append(this.extFields).append("}");
        return sb.toString();
    }
}

