/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;

public class HttpEventWrapper
implements ProtocolTransportObject {
    private Map<String, Object> headerMap = new HashMap<String, Object>();
    private Map<String, Object> sysHeaderMap = new HashMap<String, Object>();
    private byte[] body;
    private String requestURI;
    public String httpMethod;
    public String httpVersion;
    public long reqTime;
    public long resTime;

    public HttpEventWrapper() {
        this(null, null, null);
    }

    public HttpEventWrapper(String httpMethod, String httpVersion, String requestURI) {
        this.httpMethod = httpMethod;
        this.httpVersion = httpVersion;
        this.reqTime = System.currentTimeMillis();
        this.requestURI = requestURI;
    }

    public HttpEventWrapper createHttpResponse(Map<String, Object> responseHeaderMap, Map<String, Object> responseBodyMap) {
        if (StringUtils.isBlank((CharSequence)this.requestURI)) {
            return null;
        }
        HttpEventWrapper response = new HttpEventWrapper(this.httpMethod, this.httpVersion, this.requestURI);
        response.setReqTime(this.reqTime);
        response.setHeaderMap(responseHeaderMap);
        response.setBody(JsonUtils.serialize(responseBodyMap).getBytes(StandardCharsets.UTF_8));
        response.setResTime(System.currentTimeMillis());
        return response;
    }

    public HttpEventWrapper createHttpResponse(EventMeshRetCode eventMeshRetCode) {
        if (StringUtils.isBlank((CharSequence)this.requestURI)) {
            return null;
        }
        HttpEventWrapper response = new HttpEventWrapper(this.httpMethod, this.httpVersion, this.requestURI);
        response.setReqTime(this.reqTime);
        HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
        responseHeaderMap.put("requestURI", response.requestURI);
        response.setHeaderMap(responseHeaderMap);
        HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        responseBodyMap.put("retCode", eventMeshRetCode.getRetCode());
        responseBodyMap.put("retMessage", eventMeshRetCode.getErrMsg());
        response.setBody(JsonUtils.serialize(responseBodyMap).getBytes(StandardCharsets.UTF_8));
        response.setResTime(System.currentTimeMillis());
        return response;
    }

    public long getReqTime() {
        return this.reqTime;
    }

    public void setReqTime(long reqTime) {
        this.reqTime = reqTime;
    }

    public long getResTime() {
        return this.resTime;
    }

    public void setResTime(long resTime) {
        this.resTime = resTime;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public Map<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, Object> headerMap) {
        this.headerMap = headerMap;
    }

    public Map<String, Object> getSysHeaderMap() {
        return this.sysHeaderMap;
    }

    public void setSysHeaderMap(Map<String, Object> sysHeaderMap) {
        this.sysHeaderMap = sysHeaderMap;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public DefaultFullHttpResponse httpResponse() throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.body));
        HttpHeaders headers = response.headers();
        headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        headers.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        Optional.of(this.headerMap).ifPresent(customerHeader -> customerHeader.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1)));
        return response;
    }

    public void buildSysHeaderForClient() {
        this.sysHeaderMap.put("env", this.headerMap.getOrDefault("env", "env"));
        this.sysHeaderMap.put("idc", this.headerMap.getOrDefault("idc", "idc"));
        this.sysHeaderMap.put("ip", this.headerMap.getOrDefault("ip", IPUtils.getLocalAddress()));
        this.sysHeaderMap.put("pid", this.headerMap.getOrDefault("pid", ThreadUtils.getPID()));
        this.sysHeaderMap.put("sys", this.headerMap.getOrDefault("sys", "1234"));
        this.sysHeaderMap.put("username", this.headerMap.getOrDefault("username", "eventmesh"));
        this.sysHeaderMap.put("passwd", this.headerMap.getOrDefault("passwd", "pass"));
        this.sysHeaderMap.put("producergroup", this.headerMap.getOrDefault("producergroup", "em-http-producer"));
        this.sysHeaderMap.put("consumergroup", this.headerMap.getOrDefault("consumergroup", "em-http-consumer"));
        this.sysHeaderMap.put("protocoltype", "http");
        this.sysHeaderMap.put("protocoldesc", "http");
    }

    public void buildSysHeaderForCE() {
        this.sysHeaderMap.put("id", UUID.randomUUID().toString());
        this.sysHeaderMap.put("source", this.headerMap.getOrDefault("source", URI.create("/")));
        this.sysHeaderMap.put("type", this.headerMap.getOrDefault("type", "http_request"));
        String topic = this.headerMap.getOrDefault("subject", "").toString();
        if (this.requestURI.startsWith(RequestURI.PUBLISH.getRequestURI())) {
            topic = this.requestURI.substring(RequestURI.PUBLISH.getRequestURI().length() + 1);
        }
        if (StringUtils.isEmpty((CharSequence)topic)) {
            topic = "TEST-HTTP-TOPIC";
        }
        this.sysHeaderMap.put("subject", topic);
    }
}

