/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.xds;

import io.envoyproxy.envoy.config.route.v3.Route;
import io.envoyproxy.envoy.config.route.v3.RouteAction;
import io.envoyproxy.envoy.config.route.v3.RouteMatch;
import io.envoyproxy.envoy.config.route.v3.VirtualHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.cluster.router.xds.RdsRouteRuleManager;
import org.apache.dubbo.rpc.cluster.router.xds.rule.ClusterWeight;
import org.apache.dubbo.rpc.cluster.router.xds.rule.HTTPRouteDestination;
import org.apache.dubbo.rpc.cluster.router.xds.rule.HeaderMatcher;
import org.apache.dubbo.rpc.cluster.router.xds.rule.HttpRequestMatch;
import org.apache.dubbo.rpc.cluster.router.xds.rule.LongRangeMatch;
import org.apache.dubbo.rpc.cluster.router.xds.rule.PathMatcher;
import org.apache.dubbo.rpc.cluster.router.xds.rule.XdsRouteRule;

public class RdsVirtualHostListener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(RdsVirtualHostListener.class);
    private final String domain;
    private final RdsRouteRuleManager routeRuleManager;

    public RdsVirtualHostListener(String domain, RdsRouteRuleManager routeRuleManager) {
        this.domain = domain;
        this.routeRuleManager = routeRuleManager;
    }

    public void parseVirtualHost(VirtualHost virtualHost) {
        if (virtualHost == null || CollectionUtils.isEmpty((Collection)virtualHost.getRoutesList())) {
            this.routeRuleManager.notifyRuleChange(this.domain, new ArrayList<XdsRouteRule>());
            return;
        }
        try {
            List<XdsRouteRule> xdsRouteRules = virtualHost.getRoutesList().stream().map(route -> {
                if (route.getMatch().getQueryParametersCount() != 0) {
                    return null;
                }
                HttpRequestMatch match = this.parseMatch(route.getMatch());
                HTTPRouteDestination action = this.parseAction((Route)route);
                return new XdsRouteRule(match, action);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.routeRuleManager.notifyRuleChange(this.domain, xdsRouteRules);
        }
        catch (Exception e) {
            LOGGER.error("99-0", "", "", "parse domain: " + this.domain + " xds VirtualHost error", (Throwable)e);
        }
    }

    private HttpRequestMatch parseMatch(RouteMatch match) {
        PathMatcher pathMatcher = this.parsePathMatch(match);
        List<HeaderMatcher> headerMatchers = this.parseHeadMatch(match);
        return new HttpRequestMatch(pathMatcher, headerMatchers);
    }

    private PathMatcher parsePathMatch(RouteMatch match) {
        boolean caseSensitive = match.getCaseSensitive().getValue();
        PathMatcher pathMatcher = new PathMatcher();
        pathMatcher.setCaseSensitive(caseSensitive);
        switch (match.getPathSpecifierCase()) {
            case PREFIX: {
                pathMatcher.setPrefix(match.getPrefix());
                return pathMatcher;
            }
            case PATH: {
                pathMatcher.setPath(match.getPath());
                return pathMatcher;
            }
            case SAFE_REGEX: {
                String regex = match.getSafeRegex().getRegex();
                pathMatcher.setRegex(regex);
                return pathMatcher;
            }
            case PATHSPECIFIER_NOT_SET: {
                return null;
            }
        }
        throw new IllegalArgumentException("Path specifier is not expect");
    }

    private List<HeaderMatcher> parseHeadMatch(RouteMatch routeMatch) {
        ArrayList<HeaderMatcher> headerMatchers = new ArrayList<HeaderMatcher>();
        List headersList = routeMatch.getHeadersList();
        block8: for (io.envoyproxy.envoy.config.route.v3.HeaderMatcher headerMatcher : headersList) {
            HeaderMatcher matcher = new HeaderMatcher();
            matcher.setName(headerMatcher.getName());
            matcher.setInverted(headerMatcher.getInvertMatch());
            switch (headerMatcher.getHeaderMatchSpecifierCase()) {
                case EXACT_MATCH: {
                    matcher.setExactValue(headerMatcher.getExactMatch());
                    headerMatchers.add(matcher);
                    continue block8;
                }
                case SAFE_REGEX_MATCH: {
                    matcher.setRegex(headerMatcher.getSafeRegexMatch().getRegex());
                    headerMatchers.add(matcher);
                    continue block8;
                }
                case RANGE_MATCH: {
                    LongRangeMatch rang = new LongRangeMatch();
                    rang.setStart(headerMatcher.getRangeMatch().getStart());
                    rang.setEnd(headerMatcher.getRangeMatch().getEnd());
                    matcher.setRange(rang);
                    headerMatchers.add(matcher);
                    continue block8;
                }
                case PRESENT_MATCH: {
                    matcher.setPresent(headerMatcher.getPresentMatch());
                    headerMatchers.add(matcher);
                    continue block8;
                }
                case PREFIX_MATCH: {
                    matcher.setPrefix(headerMatcher.getPrefixMatch());
                    headerMatchers.add(matcher);
                    continue block8;
                }
                case SUFFIX_MATCH: {
                    matcher.setSuffix(headerMatcher.getSuffixMatch());
                    headerMatchers.add(matcher);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Header specifier is not expect");
        }
        return headerMatchers;
    }

    private HTTPRouteDestination parseAction(Route route) {
        switch (route.getActionCase()) {
            case ROUTE: {
                HTTPRouteDestination httpRouteDestination = new HTTPRouteDestination();
                RouteAction routeAction = route.getRoute();
                RouteAction.ClusterSpecifierCase clusterSpecifierCase = routeAction.getClusterSpecifierCase();
                if (clusterSpecifierCase == RouteAction.ClusterSpecifierCase.CLUSTER) {
                    httpRouteDestination.setCluster(routeAction.getCluster());
                    return httpRouteDestination;
                }
                if (clusterSpecifierCase != RouteAction.ClusterSpecifierCase.WEIGHTED_CLUSTERS) break;
                List<ClusterWeight> clusterWeights = routeAction.getWeightedClusters().getClustersList().stream().map(c -> new ClusterWeight(c.getName(), c.getWeight().getValue())).sorted(Comparator.comparing(ClusterWeight::getWeight)).collect(Collectors.toList());
                httpRouteDestination.setWeightedClusters(clusterWeights);
                return httpRouteDestination;
            }
        }
        throw new IllegalArgumentException("Cluster specifier is not expect");
    }
}

