/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util.protocol;

import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.xds.util.AdsObserver;
import org.apache.dubbo.registry.xds.util.XdsListener;
import org.apache.dubbo.registry.xds.util.protocol.DeltaResource;
import org.apache.dubbo.registry.xds.util.protocol.XdsProtocol;

public abstract class AbstractProtocol<T, S extends DeltaResource<T>>
implements XdsProtocol<T>,
XdsListener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractProtocol.class);
    protected AdsObserver adsObserver;
    protected final Node node;
    private final int checkInterval;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    protected final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    protected Set<String> observeResourcesName;
    public static final String emptyResourceName = "emptyResourcesName";
    private final ReentrantLock resourceLock = new ReentrantLock();
    protected Map<Set<String>, List<Consumer<Map<String, T>>>> consumerObserveMap = new ConcurrentHashMap<Set<String>, List<Consumer<Map<String, T>>>>();
    protected Map<String, T> resourcesMap = new ConcurrentHashMap<String, T>();

    public Map<Set<String>, List<Consumer<Map<String, T>>>> getConsumerObserveMap() {
        return this.consumerObserveMap;
    }

    public AbstractProtocol(AdsObserver adsObserver, Node node, int checkInterval) {
        this.adsObserver = adsObserver;
        this.node = node;
        this.checkInterval = checkInterval;
        adsObserver.addListener(this);
    }

    public abstract String getTypeUrl();

    public boolean isCacheExistResource(Set<String> resourceNames) {
        for (String resourceName : resourceNames) {
            if ("".equals(resourceName) || this.resourcesMap.containsKey(resourceName)) continue;
            return false;
        }
        return true;
    }

    public T getCacheResource(String resourceName) {
        if (resourceName == null || resourceName.length() == 0) {
            return null;
        }
        return this.resourcesMap.get(resourceName);
    }

    @Override
    public Map<String, T> getResource(Set<String> resourceNames) {
        Set<Object> set = resourceNames = resourceNames == null ? Collections.emptySet() : resourceNames;
        if (!resourceNames.isEmpty() && this.isCacheExistResource(resourceNames)) {
            return this.getResourceFromCache(resourceNames);
        }
        return this.getResourceFromRemote(resourceNames);
    }

    private Map<String, T> getResourceFromCache(Set<String> resourceNames) {
        return resourceNames.stream().filter(o -> !StringUtils.isEmpty((String)o)).collect(Collectors.toMap(k -> k, this::getCacheResource));
    }

    /*
     * Exception decompiling
     */
    public Map<String, T> getResourceFromRemote(Set<String> resourceNames) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void observeResource(Set<String> resourceNames, Consumer<Map<String, T>> consumer, boolean isReConnect) {
        if (!isReConnect) {
            consumer.accept(this.getResource(resourceNames));
            try {
                this.writeLock.lock();
                this.consumerObserveMap.compute(resourceNames, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Consumer>();
                    }
                    v.add(consumer);
                    return v;
                });
            }
            finally {
                this.writeLock.unlock();
            }
        }
        try {
            this.writeLock.lock();
            this.observeResourcesName = this.consumerObserveMap.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void unobserveResource(Set<String> resourceNames, Consumer<Map<String, T>> consumer) {
    }

    protected DiscoveryRequest buildDiscoveryRequest(Set<String> resourceNames) {
        return DiscoveryRequest.newBuilder().setNode(this.node).setTypeUrl(this.getTypeUrl()).addAllResourceNames(resourceNames).build();
    }

    protected abstract Map<String, T> decodeDiscoveryResponse(DiscoveryResponse var1);

    @Override
    public final void process(DiscoveryResponse discoveryResponse) {
        Map<String, T> newResult = this.decodeDiscoveryResponse(discoveryResponse);
        Map<String, T> oldResource = this.resourcesMap;
        this.discoveryResponseListener(oldResource, newResult);
        this.resourcesMap = newResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoveryResponseListener(Map<String, T> oldResult, Map<String, T> newResult) {
        HashSet changedResourceNames = new HashSet();
        oldResult.forEach((key, origin) -> {
            if (!Objects.equals(origin, newResult.get(key))) {
                changedResourceNames.add(key);
            }
        });
        newResult.forEach((key, origin) -> {
            if (!Objects.equals(origin, oldResult.get(key))) {
                changedResourceNames.add(key);
            }
        });
        if (changedResourceNames.isEmpty()) {
            return;
        }
        logger.info("Receive resource update notification from xds server. Change resource count: " + changedResourceNames.stream() + ". Type: " + this.getTypeUrl());
        try {
            this.readLock.lock();
            for (Map.Entry<Set<String>, List<Consumer<Map<String, T>>>> entry : this.consumerObserveMap.entrySet()) {
                if (entry.getKey().stream().noneMatch(changedResourceNames::contains)) continue;
                Map<String, Object> dsResultMap = entry.getKey().stream().collect(Collectors.toMap(k -> k, v -> newResult.get(v)));
                entry.getValue().forEach(o -> o.accept(dsResultMap));
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static /* synthetic */ boolean lambda$getResourceFromRemote$3(Consumer futureConsumer, Consumer o) {
        return o.equals(futureConsumer);
    }

    private static /* synthetic */ List lambda$getResourceFromRemote$2(Set key) {
        return new ArrayList();
    }
}

