/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util;

import io.envoyproxy.envoy.api.v2.DeltaDiscoveryRequest;
import io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v3.DeltaDiscoveryResponse;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.registry.xds.XdsCertificateSigner;
import org.apache.dubbo.registry.xds.util.bootstrap.Bootstrapper;
import org.apache.dubbo.registry.xds.util.bootstrap.BootstrapperImpl;

public class XdsChannel {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(XdsChannel.class);
    private static final String USE_AGENT = "use-agent";
    private URL url;
    private static final String SECURE = "secure";
    private static final String PLAINTEXT = "plaintext";
    private final ManagedChannel channel;

    public URL getUrl() {
        return this.url;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public XdsChannel(URL url) {
        ManagedChannel managedChannel = null;
        this.url = url;
        try {
            if (!url.getParameter(USE_AGENT, false)) {
                if (PLAINTEXT.equals(url.getParameter(SECURE))) {
                    managedChannel = NettyChannelBuilder.forAddress((String)url.getHost(), (int)url.getPort()).usePlaintext().build();
                } else {
                    XdsCertificateSigner signer = (XdsCertificateSigner)url.getOrDefaultApplicationModel().getExtensionLoader(XdsCertificateSigner.class).getExtension(url.getParameter("signer", "istio"));
                    XdsCertificateSigner.CertPair certPair = signer.GenerateCert(url);
                    SslContext context = GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager((InputStream)new ByteArrayInputStream(certPair.getPublicKey().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(certPair.getPrivateKey().getBytes(StandardCharsets.UTF_8))).build();
                    managedChannel = NettyChannelBuilder.forAddress((String)url.getHost(), (int)url.getPort()).sslContext(context).build();
                }
            } else {
                BootstrapperImpl bootstrapper = new BootstrapperImpl();
                Bootstrapper.BootstrapInfo bootstrapInfo = bootstrapper.bootstrap();
                URLAddress address = URLAddress.parse((String)bootstrapInfo.servers().get(0).target(), null, (boolean)false);
                EpollEventLoopGroup elg = new EpollEventLoopGroup();
                managedChannel = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress("/" + address.getPath())).eventLoopGroup((EventLoopGroup)elg).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
            }
        }
        catch (Exception e) {
            logger.error("1-32", "", "", "Error occurred when creating gRPC channel to control panel.", (Throwable)e);
        }
        this.channel = managedChannel;
    }

    public StreamObserver<io.envoyproxy.envoy.service.discovery.v3.DeltaDiscoveryRequest> observeDeltaDiscoveryRequest(StreamObserver<DeltaDiscoveryResponse> observer) {
        return AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).deltaAggregatedResources(observer);
    }

    public StreamObserver<io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest> createDeltaDiscoveryRequest(StreamObserver<DiscoveryResponse> observer) {
        return AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).streamAggregatedResources(observer);
    }

    public StreamObserver<DeltaDiscoveryRequest> observeDeltaDiscoveryRequestV2(StreamObserver<io.envoyproxy.envoy.api.v2.DeltaDiscoveryResponse> observer) {
        return io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).deltaAggregatedResources(observer);
    }

    public StreamObserver<DiscoveryRequest> createDeltaDiscoveryRequestV2(StreamObserver<io.envoyproxy.envoy.api.v2.DiscoveryResponse> observer) {
        return io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).streamAggregatedResources(observer);
    }

    public void destroy() {
        this.channel.shutdown();
    }
}

