/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.client.AbstractServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.xds.XdsServiceDiscovery;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class XdsServiceDiscoveryFactory
extends AbstractServiceDiscoveryFactory {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(XdsServiceDiscoveryFactory.class);

    protected ServiceDiscovery createDiscovery(URL registryURL) {
        XdsServiceDiscovery xdsServiceDiscovery = new XdsServiceDiscovery(ApplicationModel.defaultModel(), registryURL);
        try {
            xdsServiceDiscovery.doInitialize(registryURL);
        }
        catch (Exception e) {
            logger.error("1-33", "", "", "Error occurred when initialize xDS service discovery impl.", (Throwable)e);
        }
        return xdsServiceDiscovery;
    }
}

