/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.actuate.endpoint.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.AbstractDubboMetadata;
import org.springframework.stereotype.Component;

@Component
public class DubboShutdownMetadata
extends AbstractDubboMetadata {
    public Map<String, Object> shutdown() throws Exception {
        LinkedHashMap<String, Integer> shutdownCountData = new LinkedHashMap<String, Integer>();
        int registriesCount = AbstractRegistryFactory.getRegistries().size();
        int protocolsCount = this.getProtocolConfigsBeanMap().size();
        shutdownCountData.put("registries", registriesCount);
        shutdownCountData.put("protocols", protocolsCount);
        Map<String, ServiceBean> serviceBeansMap = this.getServiceBeansMap();
        if (!serviceBeansMap.isEmpty()) {
            for (ServiceBean serviceBean : serviceBeansMap.values()) {
                serviceBean.destroy();
            }
        }
        shutdownCountData.put("services", serviceBeansMap.size());
        ReferenceAnnotationBeanPostProcessor beanPostProcessor = this.getReferenceAnnotationBeanPostProcessor();
        int referencesCount = beanPostProcessor.getReferenceBeans().size();
        beanPostProcessor.destroy();
        shutdownCountData.put("references", referencesCount);
        TreeMap<String, Object> shutdownData = new TreeMap<String, Object>();
        shutdownData.put("shutdown.count", shutdownCountData);
        return shutdownData;
    }
}

