/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import com.alibaba.com.caucho.hessian.io.Deserializer;
import com.alibaba.com.caucho.hessian.io.JavaDeserializer;
import com.alibaba.com.caucho.hessian.io.JavaSerializer;
import com.alibaba.com.caucho.hessian.io.Serializer;
import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import java.io.Serializable;
import org.apache.dubbo.common.utils.DefaultSerializeClassChecker;

public class Hessian2SerializerFactory
extends SerializerFactory {
    private final DefaultSerializeClassChecker defaultSerializeClassChecker;

    public Hessian2SerializerFactory(DefaultSerializeClassChecker defaultSerializeClassChecker) {
        this.defaultSerializeClassChecker = defaultSerializeClassChecker;
    }

    public Class<?> loadSerializedClass(String className) throws ClassNotFoundException {
        return this.defaultSerializeClassChecker.loadClass(this.getClassLoader(), className);
    }

    protected Serializer getDefaultSerializer(Class cl) {
        if (this._defaultSerializer != null) {
            return this._defaultSerializer;
        }
        try {
            this.defaultSerializeClassChecker.loadClass(this.getClassLoader(), cl.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.checkSerializable(cl);
        return new JavaSerializer(cl, this.getClassLoader());
    }

    protected Deserializer getDefaultDeserializer(Class cl) {
        try {
            this.defaultSerializeClassChecker.loadClass(this.getClassLoader(), cl.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.checkSerializable(cl);
        return new JavaDeserializer(cl);
    }

    private void checkSerializable(Class<?> cl) {
        if (!(Serializable.class.isAssignableFrom(cl) || this.isAllowNonSerializable() && !this.defaultSerializeClassChecker.isCheckSerializable())) {
            throw new IllegalStateException("Serialized class " + cl.getName() + " must implement java.io.Serializable");
        }
    }
}

