/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.service;

import io.grpc.health.v1.Health;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.tri.service.HealthStatusManager;
import org.apache.dubbo.rpc.protocol.tri.service.ReflectionV1AlphaService;
import org.apache.dubbo.rpc.protocol.tri.service.TriHealthImpl;

public class TriBuiltinService {
    private final ProxyFactory proxyFactory;
    private final PathResolver pathResolver;
    private final Health healthService;
    private final ReflectionV1AlphaService reflectionServiceV1Alpha;
    private final HealthStatusManager healthStatusManager;
    private final AtomicBoolean init = new AtomicBoolean();

    public TriBuiltinService(FrameworkModel frameworkModel) {
        this.healthStatusManager = new HealthStatusManager(new TriHealthImpl());
        this.healthService = this.healthStatusManager.getHealthService();
        this.reflectionServiceV1Alpha = new ReflectionV1AlphaService();
        this.proxyFactory = (ProxyFactory)frameworkModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        this.pathResolver = (PathResolver)frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
        this.init();
    }

    public void init() {
        if (this.init.compareAndSet(false, true)) {
            this.addSingleBuiltinService("grpc.health.v1.Health", this.healthService, Health.class);
            this.addSingleBuiltinService("grpc.reflection.v1alpha.ServerReflection", this.reflectionServiceV1Alpha, ReflectionV1AlphaService.class);
        }
    }

    private <T> void addSingleBuiltinService(String serviceName, T impl, Class<T> interfaceClass) {
        ModuleModel internalModule = ApplicationModel.defaultModel().getInternalModule();
        URL url = new ServiceConfigURL("tri", null, null, "0.0.0.0", 0, serviceName).addParameter("proxy", "nativestub").setScopeModel((ScopeModel)internalModule);
        Invoker invoker = this.proxyFactory.getInvoker(impl, interfaceClass, url);
        this.pathResolver.add(serviceName, invoker);
        internalModule.addDestroyListener(scopeModel -> this.pathResolver.remove(serviceName));
    }

    public HealthStatusManager getHealthStatusManager() {
        return this.healthStatusManager;
    }
}

