/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.injvm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.injvm.InjvmExporter;
import org.apache.dubbo.rpc.protocol.injvm.InjvmInvoker;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class InjvmProtocol
extends AbstractProtocol {
    public static final String NAME = "injvm";
    public static final int DEFAULT_PORT = 0;

    public static InjvmProtocol getInjvmProtocol(ScopeModel scopeModel) {
        return (InjvmProtocol)((Object)scopeModel.getExtensionLoader(Protocol.class).getExtension(NAME, false));
    }

    static Exporter<?> getExporter(Map<String, Exporter<?>> map, URL key) {
        Exporter<?> result = null;
        if (!key.getServiceKey().contains("*")) {
            result = map.get(key.getServiceKey());
        } else if (CollectionUtils.isNotEmptyMap(map)) {
            for (Exporter<?> exporter : map.values()) {
                if (!UrlUtils.isServiceKeyMatch((URL)key, (URL)exporter.getInvoker().getUrl())) continue;
                result = exporter;
                break;
            }
        }
        if (result == null) {
            return null;
        }
        if (ProtocolUtils.isGeneric((String)result.getInvoker().getUrl().getParameter("generic"))) {
            return null;
        }
        return result;
    }

    public int getDefaultPort() {
        return 0;
    }

    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        return new InjvmExporter<T>(invoker, invoker.getUrl().getServiceKey(), this.exporterMap);
    }

    public <T> Invoker<T> protocolBindingRefer(Class<T> serviceType, URL url) throws RpcException {
        String group = url.getParameter("group");
        if (StringUtils.isNotEmpty((String)group) && (CommonConstants.COMMA_SPLIT_PATTERN.split(group).length > 1 || "*".equals(group))) {
            return this.doCreateInvoker(url, Cluster.getCluster((ScopeModel)url.getScopeModel(), (String)"mergeable"), serviceType);
        }
        Cluster cluster = Cluster.getCluster((ScopeModel)url.getScopeModel(), (String)url.getParameter("cluster"));
        return this.doCreateInvoker(url, cluster, serviceType);
    }

    public boolean isInjvmRefer(URL url) {
        String scope = url.getParameter("scope");
        if ("local".equals(scope) || url.getParameter(NAME, false)) {
            return true;
        }
        if ("remote".equals(scope)) {
            return false;
        }
        if (url.getParameter("generic", false)) {
            return false;
        }
        if (InjvmProtocol.getExporter(this.exporterMap, url) != null) {
            return !"broadcast".equalsIgnoreCase(url.getParameter("cluster"));
        }
        return false;
    }

    protected <T> ClusterInvoker<T> doCreateInvoker(URL url, Cluster cluster, Class<T> type) {
        StaticDirectory directory = new StaticDirectory(url, this.getInvokers(this.exporterMap, url, type));
        return (ClusterInvoker)cluster.join((Directory)directory, true);
    }

    private <T> List<Invoker<T>> getInvokers(Map<String, Exporter<?>> map, URL url, Class<T> type) {
        ArrayList<Invoker<T>> result = new ArrayList<Invoker<T>>();
        if (!url.getServiceKey().contains("*")) {
            Exporter<?> exporter = map.get(url.getServiceKey());
            InjvmInvoker<T> invoker = new InjvmInvoker<T>(type, url, url.getServiceKey(), exporter);
            result.add((Invoker<T>)invoker);
        } else if (CollectionUtils.isNotEmptyMap(map)) {
            for (Exporter<?> exporter : map.values()) {
                if (!UrlUtils.isServiceKeyMatch((URL)url, (URL)exporter.getInvoker().getUrl())) continue;
                URL providerUrl = exporter.getInvoker().getUrl();
                URL consumerUrl = url.addParameter("group", providerUrl.getGroup()).addParameter("version", providerUrl.getVersion());
                InjvmInvoker<T> invoker = new InjvmInvoker<T>(type, consumerUrl, consumerUrl.getServiceKey(), exporter);
                result.add((Invoker<T>)invoker);
            }
        }
        return result;
    }
}

