/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.monitor.dubbo;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.monitor.Monitor;
import org.apache.dubbo.monitor.MonitorService;
import org.apache.dubbo.monitor.dubbo.DubboMonitor;
import org.apache.dubbo.monitor.support.AbstractMonitorFactory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;

public class DubboMonitorFactory
extends AbstractMonitorFactory {
    private Protocol protocol;
    private ProxyFactory proxyFactory;

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    protected Monitor createMonitor(URL url) {
        String filter;
        URLBuilder urlBuilder = URLBuilder.from((URL)url);
        urlBuilder.setProtocol(url.getParameter("protocol", "dubbo"));
        if (StringUtils.isEmpty((String)url.getPath())) {
            urlBuilder.setPath(MonitorService.class.getName());
        }
        filter = StringUtils.isEmpty((String)(filter = url.getParameter("reference.filter"))) ? "" : filter + ",";
        urlBuilder.addParameters(new String[]{"check", String.valueOf(false), "reference.filter", filter + "-monitor"});
        Invoker monitorInvoker = this.protocol.refer(MonitorService.class, (URL)urlBuilder.build());
        MonitorService monitorService = (MonitorService)this.proxyFactory.getProxy(monitorInvoker);
        return new DubboMonitor((Invoker<MonitorService>)monitorInvoker, monitorService);
    }
}

