/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.util.Objects;

public class PathMatcher {
    private static final String SEPARATOR = "/";
    private String path;
    private String version;
    private String group;
    private Integer port;
    private String[] pathSplits;
    private boolean hasPathVariable;

    public PathMatcher(String path) {
        this(path, null, null, 0);
    }

    public PathMatcher(String path, String version, String group, Integer port) {
        this.path = path;
        for (String pathSplit : this.pathSplits = path.split(SEPARATOR)) {
            if (!this.isPlaceHold(pathSplit)) continue;
            this.hasPathVariable = true;
            break;
        }
        this.version = version;
        this.group = group;
        this.port = port;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathMatcher that = (PathMatcher)o;
        return this.pathEqual(that.path) && Objects.equals(this.version, that.version) && Objects.equals(this.group, that.group) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.group, this.port);
    }

    private boolean pathEqual(String path) {
        if (!this.hasPathVariable) {
            return this.path.equals(path);
        }
        String[] split = path.split(SEPARATOR);
        if (split.length != this.pathSplits.length) {
            return false;
        }
        for (int i = 0; i < this.pathSplits.length; ++i) {
            boolean equals = split[i].equals(this.pathSplits[i]);
            if (equals || this.placeHoldCompare(this.pathSplits[i])) continue;
            return false;
        }
        return true;
    }

    private boolean placeHoldCompare(String pathSplit) {
        boolean lengthCondition;
        boolean startAndEndEqual = this.isPlaceHold(pathSplit);
        if (!startAndEndEqual) {
            return false;
        }
        boolean bl = lengthCondition = pathSplit.length() >= 3;
        return lengthCondition;
    }

    private boolean isPlaceHold(String pathSplit) {
        return pathSplit.startsWith("{") && pathSplit.endsWith("}");
    }

    public String toString() {
        return "PathMather{path='" + this.path + '\'' + ", version='" + this.version + '\'' + ", group='" + this.group + '\'' + ", port='" + this.port + '\'' + '}';
    }
}

