/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metrics.config.event.ConfigCenterEvent;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.EventType;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ZookeeperDataListener
implements DataListener {
    private String path;
    private String key;
    private String group;
    private Set<ConfigurationListener> listeners;
    private ApplicationModel applicationModel;

    public ZookeeperDataListener(String path, String key, String group, ApplicationModel applicationModel) {
        this.path = path;
        this.key = key;
        this.group = group;
        this.listeners = new CopyOnWriteArraySet<ConfigurationListener>();
        this.applicationModel = applicationModel;
    }

    public void addListener(ConfigurationListener configurationListener) {
        this.listeners.add(configurationListener);
    }

    public void removeListener(ConfigurationListener configurationListener) {
        this.listeners.remove(configurationListener);
    }

    public Set<ConfigurationListener> getListeners() {
        return this.listeners;
    }

    public void dataChanged(String path, Object value, EventType eventType) {
        if (!this.path.equals(path)) {
            return;
        }
        ConfigChangeType changeType = EventType.NodeCreated.equals((Object)eventType) ? ConfigChangeType.ADDED : (value == null ? ConfigChangeType.DELETED : ConfigChangeType.MODIFIED);
        ConfigChangedEvent configChangeEvent = new ConfigChangedEvent(this.key, this.group, (String)value, changeType);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            this.listeners.forEach(listener -> listener.process(configChangeEvent));
        }
        MetricsEventBus.publish((MetricsEvent)ConfigCenterEvent.toChangeEvent((ApplicationModel)this.applicationModel, (String)configChangeEvent.getKey(), (String)configChangeEvent.getGroup(), (String)"zookeeper", (String)ConfigChangeType.ADDED.name(), (int)1));
    }
}

