/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component.param;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.dubbo.common.url.component.param.ParamValue;

public class FixedParamValue
implements ParamValue {
    private final String[] values;
    private final Map<String, Integer> val2Index;

    public FixedParamValue(String ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("the array size of values should be larger than 0");
        }
        this.values = values;
        HashMap<String, Integer> valueMap = new HashMap<String, Integer>(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            valueMap.put(values[i].toLowerCase(Locale.ROOT), i);
        }
        this.val2Index = Collections.unmodifiableMap(valueMap);
    }

    @Override
    public String getN(Integer n) {
        return this.values[n];
    }

    @Override
    public Integer getIndex(String value) {
        Integer offset = this.val2Index.get(value.toLowerCase(Locale.ROOT));
        if (offset == null) {
            throw new IllegalArgumentException("unrecognized value " + value + " , please check if value is illegal. Permitted values: " + Arrays.asList(this.values));
        }
        return offset;
    }

    @Override
    public String defaultVal() {
        return this.values[0];
    }
}

