/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension.inject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.context.Lifecycle;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionInjector;
import org.apache.dubbo.common.extension.ExtensionLoader;

@Adaptive
public class AdaptiveExtensionInjector
implements ExtensionInjector,
Lifecycle {
    private List<ExtensionInjector> injectors = Collections.emptyList();
    private ExtensionAccessor extensionAccessor;

    @Override
    public void setExtensionAccessor(ExtensionAccessor extensionAccessor) {
        this.extensionAccessor = extensionAccessor;
    }

    @Override
    public void initialize() throws IllegalStateException {
        ExtensionLoader<ExtensionInjector> loader = this.extensionAccessor.getExtensionLoader(ExtensionInjector.class);
        ArrayList<ExtensionInjector> list = new ArrayList<ExtensionInjector>();
        for (String name : loader.getSupportedExtensions()) {
            list.add(loader.getExtension(name));
        }
        this.injectors = Collections.unmodifiableList(list);
    }

    @Override
    public <T> T getInstance(Class<T> type, String name) {
        for (ExtensionInjector injector : this.injectors) {
            T extension = injector.getInstance(type, name);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }

    @Override
    public void start() throws IllegalStateException {
    }

    @Override
    public void destroy() throws IllegalStateException {
    }
}

