/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.configurator;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.configurator.parser.model.ConditionMatch;

public abstract class AbstractConfigurator
implements Configurator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigurator.class);
    private static final String TILDE = "~";
    private final URL configuratorUrl;

    public AbstractConfigurator(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("configurator url == null");
        }
        this.configuratorUrl = url;
    }

    @Override
    public URL getUrl() {
        return this.configuratorUrl;
    }

    @Override
    public URL configure(URL url) {
        if (!this.configuratorUrl.getParameter("enabled", true) || this.configuratorUrl.getHost() == null || url == null || url.getHost() == null) {
            logger.info("Cannot apply configurator rule, the rule is disabled or is invalid: \n" + this.configuratorUrl);
            return url;
        }
        String apiVersion = this.configuratorUrl.getParameter("configVersion");
        if (StringUtils.isNotEmpty((String)apiVersion)) {
            String configuratorSide;
            String currentSide = url.getSide();
            if (currentSide.equals(configuratorSide = this.configuratorUrl.getSide()) && "consumer".equals(configuratorSide)) {
                url = this.configureIfMatch(NetUtils.getLocalHost(), url);
            } else if (currentSide.equals(configuratorSide) && "provider".equals(configuratorSide)) {
                url = this.configureIfMatch(url.getHost(), url);
            }
        } else {
            url = this.configureDeprecated(url);
        }
        return url;
    }

    @Deprecated
    private URL configureDeprecated(URL url) {
        if (this.configuratorUrl.getPort() != 0) {
            if (url.getPort() == this.configuratorUrl.getPort()) {
                return this.configureIfMatch(url.getHost(), url);
            }
        } else {
            if (url.getSide("provider").equals("consumer")) {
                return this.configureIfMatch(NetUtils.getLocalHost(), url);
            }
            if (url.getSide("consumer").equals("provider")) {
                return this.configureIfMatch("0.0.0.0", url);
            }
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     */
    private URL configureIfMatch(String host, URL url) {
        if (!"0.0.0.0".equals(this.configuratorUrl.getHost()) && !host.equals(this.configuratorUrl.getHost())) {
            logger.debug("Cannot apply configurator rule, host mismatch, current host is " + host + ", host in rule is " + this.configuratorUrl.getHost());
            return url;
        }
        if (!this.isV27ConditionMatchOrUnset(url)) return url;
        Set<String> conditionKeys = this.genConditionKeys();
        String apiVersion = this.configuratorUrl.getParameter("configVersion");
        if (apiVersion != null && apiVersion.startsWith("v3.0")) {
            ConditionMatch matcher = (ConditionMatch)this.configuratorUrl.getAttribute("MATCH_CONDITION");
            if (matcher == null) return this.doConfigure(url, this.configuratorUrl.removeParameters(conditionKeys));
            if (matcher.isMatch(url)) {
                return this.doConfigure(url, this.configuratorUrl.removeParameters(conditionKeys));
            }
            logger.debug("Cannot apply configurator rule, param mismatch, current params are " + url + ", params in rule is " + matcher);
            return url;
        }
        if (!this.isDeprecatedConditionMatch(conditionKeys, url)) return url;
        return this.doConfigure(url, this.configuratorUrl.removeParameters(conditionKeys));
    }

    private boolean isV27ConditionMatchOrUnset(URL url) {
        String providers = this.configuratorUrl.getParameter("providerAddresses");
        if (StringUtils.isNotEmpty((String)providers)) {
            String[] providerAddresses;
            boolean match = false;
            for (String address : providerAddresses = providers.split(",")) {
                if (!address.equals(url.getAddress()) && !address.equals("0.0.0.0") && !address.equals("0.0.0.0:*") && !address.equals("0.0.0.0:" + url.getPort()) && !address.equals(url.getHost())) continue;
                match = true;
            }
            if (!match) {
                logger.debug("Cannot apply configurator rule, provider address mismatch, current address " + url.getAddress() + ", address in rule is " + providers);
                return false;
            }
        }
        String configApplication = this.configuratorUrl.getApplication(this.configuratorUrl.getUsername());
        String currentApplication = url.getApplication(url.getUsername());
        if (configApplication != null && !"*".equals(configApplication) && !configApplication.equals(currentApplication)) {
            logger.debug("Cannot apply configurator rule, application name mismatch, current application is " + currentApplication + ", application in rule is " + configApplication);
            return false;
        }
        String configServiceKey = this.configuratorUrl.getServiceKey();
        String currentServiceKey = url.getServiceKey();
        if (!"*".equals(configServiceKey) && !configServiceKey.equals(currentServiceKey)) {
            logger.debug("Cannot apply configurator rule, service mismatch, current service is " + currentServiceKey + ", service in rule is " + configServiceKey);
            return false;
        }
        return true;
    }

    private boolean isDeprecatedConditionMatch(Set<String> conditionKeys, URL url) {
        boolean result = true;
        for (Map.Entry entry : this.configuratorUrl.getParameters().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            boolean startWithTilde = this.startWithTilde(key);
            if (!startWithTilde && !"application".equals(key) && !"side".equals(key)) continue;
            if (startWithTilde) {
                conditionKeys.add(key);
            }
            if (value == null || "*".equals(value) || value.equals(url.getParameter(startWithTilde ? key.substring(1) : key))) continue;
            result = false;
            break;
        }
        return result;
    }

    private Set<String> genConditionKeys() {
        HashSet<String> conditionKeys = new HashSet<String>();
        conditionKeys.add("category");
        conditionKeys.add("check");
        conditionKeys.add("dynamic");
        conditionKeys.add("enabled");
        conditionKeys.add("group");
        conditionKeys.add("version");
        conditionKeys.add("application");
        conditionKeys.add("side");
        conditionKeys.add("configVersion");
        conditionKeys.add("compatible_config");
        conditionKeys.add("interfaces");
        return conditionKeys;
    }

    private boolean startWithTilde(String key) {
        return StringUtils.isNotEmpty((String)key) && key.startsWith(TILDE);
    }

    protected abstract URL doConfigure(URL var1, URL var2);
}

