/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.indexing.kafka.KafkaIndexTaskTuningConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.indexing.TuningConfigs;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KafkaSupervisorTuningConfig
extends KafkaIndexTaskTuningConfig
implements SeekableStreamSupervisorTuningConfig {
    private static final String DEFAULT_OFFSET_FETCH_PERIOD = "PT30S";
    private final Integer workerThreads;
    private final Integer chatThreads;
    private final Long chatRetries;
    private final Duration httpTimeout;
    private final Duration shutdownTimeout;
    private final Duration offsetFetchPeriod;

    public static KafkaSupervisorTuningConfig defaultConfig() {
        return new KafkaSupervisorTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public KafkaSupervisorTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") Long maxBytesInMemory, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="maxTotalRows") Long maxTotalRows, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") Boolean resetOffsetAutomatically, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="workerThreads") Integer workerThreads, @JsonProperty(value="chatThreads") Integer chatThreads, @JsonProperty(value="chatRetries") Long chatRetries, @JsonProperty(value="httpTimeout") Period httpTimeout, @JsonProperty(value="shutdownTimeout") Period shutdownTimeout, @JsonProperty(value="offsetFetchPeriod") Period offsetFetchPeriod, @JsonProperty(value="intermediateHandoffPeriod") Period intermediateHandoffPeriod, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions) {
        super(maxRowsInMemory, maxBytesInMemory, maxRowsPerSegment, maxTotalRows, intermediatePersistPeriod, basePersistDirectory, maxPendingPersists, indexSpec, indexSpecForIntermediatePersists, true, reportParseExceptions, handoffConditionTimeout, resetOffsetAutomatically, segmentWriteOutMediumFactory, intermediateHandoffPeriod, logParseExceptions, maxParseExceptions, maxSavedParseExceptions);
        this.workerThreads = workerThreads;
        this.chatThreads = chatThreads;
        this.chatRetries = chatRetries != null ? chatRetries : 8L;
        this.httpTimeout = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)httpTimeout, (String)"PT10S");
        this.shutdownTimeout = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)shutdownTimeout, (String)"PT80S");
        this.offsetFetchPeriod = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)offsetFetchPeriod, (String)DEFAULT_OFFSET_FETCH_PERIOD);
    }

    @JsonProperty
    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    @JsonProperty
    public Integer getChatThreads() {
        return this.chatThreads;
    }

    @JsonProperty
    public Long getChatRetries() {
        return this.chatRetries;
    }

    @JsonProperty
    public Duration getHttpTimeout() {
        return this.httpTimeout;
    }

    @JsonProperty
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public Duration getRepartitionTransitionDuration() {
        return SeekableStreamSupervisorTuningConfig.defaultDuration(null, (String)"PT2M");
    }

    @JsonProperty
    public Duration getOffsetFetchPeriod() {
        return this.offsetFetchPeriod;
    }

    @Override
    public String toString() {
        return "KafkaSupervisorTuningConfig{maxRowsInMemory=" + this.getMaxRowsInMemory() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegment() + ", maxTotalRows=" + this.getMaxTotalRows() + ", maxBytesInMemory=" + TuningConfigs.getMaxBytesInMemoryOrDefault((long)this.getMaxBytesInMemory()) + ", intermediatePersistPeriod=" + this.getIntermediatePersistPeriod() + ", basePersistDirectory=" + this.getBasePersistDirectory() + ", maxPendingPersists=" + this.getMaxPendingPersists() + ", indexSpec=" + this.getIndexSpec() + ", reportParseExceptions=" + this.isReportParseExceptions() + ", handoffConditionTimeout=" + this.getHandoffConditionTimeout() + ", resetOffsetAutomatically=" + this.isResetOffsetAutomatically() + ", segmentWriteOutMediumFactory=" + this.getSegmentWriteOutMediumFactory() + ", workerThreads=" + this.workerThreads + ", chatThreads=" + this.chatThreads + ", chatRetries=" + this.chatRetries + ", httpTimeout=" + this.httpTimeout + ", shutdownTimeout=" + this.shutdownTimeout + ", offsetFetchPeriod=" + this.offsetFetchPeriod + ", intermediateHandoffPeriod=" + this.getIntermediateHandoffPeriod() + ", logParseExceptions=" + this.isLogParseExceptions() + ", maxParseExceptions=" + this.getMaxParseExceptions() + ", maxSavedParseExceptions=" + this.getMaxSavedParseExceptions() + '}';
    }

    public KafkaIndexTaskTuningConfig convertToTaskTuningConfig() {
        return new KafkaIndexTaskTuningConfig(this.getMaxRowsInMemory(), this.getMaxBytesInMemory(), this.getMaxRowsPerSegment(), this.getMaxTotalRows(), this.getIntermediatePersistPeriod(), this.getBasePersistDirectory(), this.getMaxPendingPersists(), this.getIndexSpec(), this.getIndexSpecForIntermediatePersists(), true, this.isReportParseExceptions(), this.getHandoffConditionTimeout(), this.isResetOffsetAutomatically(), this.getSegmentWriteOutMediumFactory(), this.getIntermediateHandoffPeriod(), this.isLogParseExceptions(), this.getMaxParseExceptions(), this.getMaxSavedParseExceptions());
    }
}

