/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.dolphinscheduler.alert.template.AlertTemplate;
import org.apache.dolphinscheduler.alert.template.AlertTemplateFactory;
import org.apache.dolphinscheduler.alert.utils.ExcelUtils;
import org.apache.dolphinscheduler.alert.utils.PropertyUtils;
import org.apache.dolphinscheduler.common.enums.ShowType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtils {
    public static final Logger logger = LoggerFactory.getLogger(MailUtils.class);
    public static final String MAIL_PROTOCOL = PropertyUtils.getString("mail.protocol");
    public static final String MAIL_SERVER_HOST = PropertyUtils.getString("mail.server.host");
    public static final Integer MAIL_SERVER_PORT = PropertyUtils.getInt("mail.server.port");
    public static final String MAIL_SENDER = PropertyUtils.getString("mail.sender");
    public static final String MAIL_USER = PropertyUtils.getString("mail.user");
    public static final String MAIL_PASSWD = PropertyUtils.getString("mail.passwd");
    public static final String XLS_FILE_PATH = PropertyUtils.getString("xls.file.path", "/tmp/xls");
    public static final String STARTTLS_ENABLE = PropertyUtils.getString("mail.smtp.starttls.enable");
    public static final String SSL_ENABLE = PropertyUtils.getString("mail.smtp.ssl.enable");
    public static final String SSL_TRUST = PropertyUtils.getString("mail.smtp.ssl.trust");
    public static final AlertTemplate alertTemplate = AlertTemplateFactory.getMessageTemplate();

    public static Map<String, Object> sendMails(Collection<String> receivers, String title, String content, String showType) {
        return MailUtils.sendMails(receivers, null, title, content, showType);
    }

    public static Map<String, Object> sendMails(Collection<String> receivers, Collection<String> receiversCc, String title, String content, String showType) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("status", false);
        if (CollectionUtils.isEmpty(receivers) && CollectionUtils.isEmpty(receiversCc)) {
            return retMap;
        }
        receivers.removeIf(StringUtils::isEmpty);
        if (showType.equals(ShowType.TABLE.getDescp()) || showType.equals(ShowType.TEXT.getDescp())) {
            HtmlEmail email = new HtmlEmail();
            try {
                Session session = MailUtils.getSession();
                email.setMailSession(session);
                email.setFrom(MAIL_SENDER);
                email.setCharset("UTF-8");
                if (CollectionUtils.isNotEmpty(receivers)) {
                    for (String receiver : receivers) {
                        email.addTo(receiver);
                    }
                }
                if (CollectionUtils.isNotEmpty(receiversCc)) {
                    for (String receiverCc : receiversCc) {
                        email.addCc(receiverCc);
                    }
                }
                return MailUtils.getStringObjectMap(title, content, showType, retMap, email);
            }
            catch (Exception e) {
                MailUtils.handleException(receivers, retMap, e);
            }
        } else if (showType.equals(ShowType.ATTACHMENT.getDescp()) || showType.equals(ShowType.TABLEATTACHMENT.getDescp())) {
            try {
                String partContent = showType.equals(ShowType.ATTACHMENT.getDescp()) ? "Please see the attachment " + title + ".xls" : MailUtils.htmlTable(content, false);
                MailUtils.attachment(receivers, receiversCc, title, content, partContent);
                retMap.put("status", true);
                return retMap;
            }
            catch (Exception e) {
                MailUtils.handleException(receivers, retMap, e);
                return retMap;
            }
        }
        return retMap;
    }

    private static String htmlTable(String content, boolean showAll) {
        return alertTemplate.getMessageFromTemplate(content, ShowType.TABLE, showAll);
    }

    private static String htmlTable(String content) {
        return MailUtils.htmlTable(content, true);
    }

    private static String htmlText(String content) {
        return alertTemplate.getMessageFromTemplate(content, ShowType.TEXT);
    }

    private static void attachment(Collection<String> receivers, Collection<String> receiversCc, String title, String content, String partContent) throws Exception {
        MimeMessage msg = MailUtils.getMimeMessage(receivers);
        MailUtils.attachContent(receiversCc, title, content, partContent, msg);
    }

    private static MimeMessage getMimeMessage(Collection<String> receivers) throws MessagingException {
        Session session = MailUtils.getSession();
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(MAIL_SENDER));
        for (String receiver : receivers) {
            msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)receiver));
        }
        return msg;
    }

    private static Session getSession() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", MAIL_SERVER_HOST);
        props.setProperty("mail.smtp.port", String.valueOf(MAIL_SERVER_PORT));
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", MAIL_PROTOCOL);
        props.setProperty("mail.smtp.starttls.enable", STARTTLS_ENABLE);
        props.setProperty("mail.smtp.ssl.enable", SSL_ENABLE);
        props.setProperty("mail.smtp.ssl.trust", SSL_TRUST);
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MAIL_USER, MAIL_PASSWD);
            }
        };
        return Session.getInstance((Properties)props, (Authenticator)auth);
    }

    private static void attachContent(Collection<String> receiversCc, String title, String content, String partContent, MimeMessage msg) throws MessagingException, IOException {
        if (CollectionUtils.isNotEmpty(receiversCc)) {
            for (String receiverCc : receiversCc) {
                msg.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)receiverCc));
            }
        }
        msg.setSubject(title);
        MimeMultipart partList = new MimeMultipart();
        MimeBodyPart part1 = new MimeBodyPart();
        part1.setContent((Object)partContent, "text/html;charset=utf-8");
        MimeBodyPart part2 = new MimeBodyPart();
        File file = new File(XLS_FILE_PATH + "/" + title + ".xls");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        ExcelUtils.genExcelFile(content, title, XLS_FILE_PATH);
        part2.attachFile(file);
        part2.setFileName(MimeUtility.encodeText((String)(title + ".xls"), (String)"UTF-8", (String)"B"));
        partList.addBodyPart((BodyPart)part1);
        partList.addBodyPart((BodyPart)part2);
        msg.setContent((Multipart)partList);
        Transport.send((Message)msg);
        MailUtils.deleteFile(file);
    }

    private static Map<String, Object> getStringObjectMap(String title, String content, String showType, Map<String, Object> retMap, HtmlEmail email) throws EmailException {
        email.setSubject(title);
        if (showType.equals(ShowType.TABLE.getDescp())) {
            email.setMsg(MailUtils.htmlTable(content));
        } else if (showType.equals(ShowType.TEXT.getDescp())) {
            email.setMsg(MailUtils.htmlText(content));
        }
        email.send();
        retMap.put("status", true);
        return retMap;
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.delete()) {
                logger.info("delete success: {}", (Object)(file.getAbsolutePath() + file.getName()));
            } else {
                logger.info("delete fail: {}", (Object)(file.getAbsolutePath() + file.getName()));
            }
        } else {
            logger.info("file not exists: {}", (Object)(file.getAbsolutePath() + file.getName()));
        }
    }

    private static void handleException(Collection<String> receivers, Map<String, Object> retMap, Exception e) {
        logger.error("Send email to {} failed", receivers, (Object)e);
        retMap.put("message", "Send email to {" + String.join((CharSequence)",", receivers) + "} failed\uff0c" + e.toString());
    }
}

