/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.utils;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger logger = LoggerFactory.getLogger(JSONUtils.class);

    public static String toJsonString(Object object) {
        try {
            return JSON.toJSONString((Object)object, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException("Json deserialization exception.", e);
        }
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return Collections.emptyList();
        }
        try {
            return JSON.parseArray((String)json, clazz);
        }
        catch (Exception e) {
            logger.error("JSONArray.parseArray exception!", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

