/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.alert.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);

    public static void genExcelFile(String content, String title, String xlsFilePath) {
        List<LinkedHashMap> itemsList = JSONUtils.toList(content, LinkedHashMap.class);
        if (CollectionUtils.isEmpty(itemsList)) {
            logger.error("itemsList is null");
            throw new RuntimeException("itemsList is null");
        }
        LinkedHashMap headerMap = itemsList.get(0);
        ArrayList headerList = new ArrayList();
        for (Map.Entry en : headerMap.entrySet()) {
            headerList.add(en.getKey());
        }
        HSSFWorkbook wb = null;
        FileOutputStream fos = null;
        try {
            wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet();
            HSSFRow row = sheet.createRow(0);
            row.setHeight((short)500);
            HSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            for (int i = 0; i < headerList.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellValue((String)headerList.get(i));
            }
            int rowIndex = 1;
            for (LinkedHashMap itemsMap : itemsList) {
                Object[] values = itemsMap.values().toArray();
                row = sheet.createRow(rowIndex);
                row.setHeight((short)500);
                ++rowIndex;
                for (int j = 0; j < values.length; ++j) {
                    HSSFCell cell1 = row.createCell(j);
                    cell1.setCellStyle((CellStyle)cellStyle);
                    cell1.setCellValue(String.valueOf(values[j]));
                }
            }
            for (int i = 0; i < headerList.size(); ++i) {
                sheet.setColumnWidth(i, ((String)headerList.get(i)).length() * 800);
            }
            File file = new File(xlsFilePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            fos = new FileOutputStream(xlsFilePath + "/" + title + ".xls");
            wb.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.error("generate excel error", (Throwable)e);
            throw new RuntimeException("generate excel error", e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

