/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dolphinscheduler.alert.utils.FuncUtils;
import org.apache.dolphinscheduler.alert.utils.JSONUtils;
import org.apache.dolphinscheduler.alert.utils.PropertyUtils;
import org.apache.dolphinscheduler.common.enums.ShowType;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.plugin.model.AlertData;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseWeChatUtils {
    public static final Logger logger = LoggerFactory.getLogger(EnterpriseWeChatUtils.class);
    private static final String ENTERPRISE_WE_CHAT_CORP_ID = PropertyUtils.getString("enterprise.wechat.corp.id");
    private static final String ENTERPRISE_WE_CHAT_SECRET = PropertyUtils.getString("enterprise.wechat.secret");
    private static final String ENTERPRISE_WE_CHAT_TOKEN_URL = PropertyUtils.getString("enterprise.wechat.token.url");
    private static final String ENTERPRISE_WE_CHAT_TOKEN_URL_REPLACE = ENTERPRISE_WE_CHAT_TOKEN_URL == null ? null : ENTERPRISE_WE_CHAT_TOKEN_URL.replaceAll("\\$corpId", ENTERPRISE_WE_CHAT_CORP_ID).replaceAll("\\$secret", ENTERPRISE_WE_CHAT_SECRET);
    private static final String ENTERPRISE_WE_CHAT_PUSH_URL = PropertyUtils.getString("enterprise.wechat.push.url");
    private static final String ENTERPRISE_WE_CHAT_TEAM_SEND_MSG = PropertyUtils.getString("enterprise.wechat.team.send.msg");
    private static final String ENTERPRISE_WE_CHAT_USER_SEND_MSG = PropertyUtils.getString("enterprise.wechat.user.send.msg");
    public static final String ENTERPRISE_WE_CHAT_AGENT_ID = PropertyUtils.getString("enterprise.wechat.agent.id");
    public static final String ENTERPRISE_WE_CHAT_USERS = PropertyUtils.getString("enterprise.wechat.users");

    public static boolean isEnable() {
        Boolean isEnable = null;
        try {
            isEnable = PropertyUtils.getBoolean("enterprise.wechat.enable");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (isEnable == null) {
            return false;
        }
        return isEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken() throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String resp;
            HttpGet httpGet = new HttpGet(ENTERPRISE_WE_CHAT_TOKEN_URL_REPLACE);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            Map map = (Map)JSON.parseObject((String)resp, (Type)new TypeToken<Map<String, Object>>(){}.getType(), (Feature[])new Feature[0]);
            String string = map.get("access_token").toString();
            return string;
        }
    }

    public static String makeTeamSendMsg(String toParty, String agentId, String msg) {
        return ENTERPRISE_WE_CHAT_TEAM_SEND_MSG.replaceAll("\\$toParty", toParty).replaceAll("\\$agentId", agentId).replaceAll("\\$msg", msg);
    }

    public static String makeTeamSendMsg(Collection<String> toParty, String agentId, String msg) {
        String listParty = FuncUtils.mkString(toParty, "|");
        return ENTERPRISE_WE_CHAT_TEAM_SEND_MSG.replaceAll("\\$toParty", listParty).replaceAll("\\$agentId", agentId).replaceAll("\\$msg", msg);
    }

    public static String makeUserSendMsg(String toUser, String agentId, String msg) {
        return ENTERPRISE_WE_CHAT_USER_SEND_MSG.replaceAll("\\$toUser", toUser).replaceAll("\\$agentId", agentId).replaceAll("\\$msg", msg);
    }

    public static String makeUserSendMsg(Collection<String> toUser, String agentId, String msg) {
        String listUser = FuncUtils.mkString(toUser, "|");
        return ENTERPRISE_WE_CHAT_USER_SEND_MSG.replaceAll("\\$toUser", listUser).replaceAll("\\$agentId", agentId).replaceAll("\\$msg", msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendEnterpriseWeChat(String charset, String data, String token) throws IOException {
        String enterpriseWeChatPushUrlReplace = ENTERPRISE_WE_CHAT_PUSH_URL.replaceAll("\\$token", token);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String resp;
            HttpPost httpPost = new HttpPost(enterpriseWeChatPushUrlReplace);
            httpPost.setEntity((HttpEntity)new StringEntity(data, charset));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)charset);
                EntityUtils.consume((HttpEntity)entity);
            }
            logger.info("Enterprise WeChat send [{}], param:{}, resp:{}", new Object[]{ENTERPRISE_WE_CHAT_PUSH_URL, data, resp});
            String string = resp;
            return string;
        }
    }

    public static String markdownTable(String title, String content) {
        List<LinkedHashMap> mapItemsList = JSONUtils.toList(content, LinkedHashMap.class);
        StringBuilder contents = new StringBuilder(200);
        if (null != mapItemsList) {
            for (LinkedHashMap mapItems : mapItemsList) {
                Set entries = mapItems.entrySet();
                Iterator iterator = entries.iterator();
                StringBuilder t = new StringBuilder(String.format("`%s`%s", title, "\n"));
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    t.append(">");
                    t.append((String)entry.getKey()).append(":").append((String)entry.getValue());
                    t.append("\n");
                }
                contents.append((CharSequence)t);
            }
        }
        return contents.toString();
    }

    public static String markdownText(String title, String content) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            List<String> list;
            try {
                list = JSONUtils.toList(content, String.class);
            }
            catch (Exception e) {
                logger.error("json format exception", (Throwable)e);
                return null;
            }
            StringBuilder contents = new StringBuilder(100);
            contents.append(String.format("`%s`%n", title));
            for (String str : list) {
                contents.append(">");
                contents.append(str);
                contents.append("\n");
            }
            return contents.toString();
        }
        return null;
    }

    public static String markdownByAlert(AlertData alert) {
        String result = "";
        if (alert.getShowType().equals(ShowType.TABLE.getDescp())) {
            result = EnterpriseWeChatUtils.markdownTable(alert.getTitle(), alert.getContent());
        } else if (alert.getShowType().equals(ShowType.TEXT.getDescp())) {
            result = EnterpriseWeChatUtils.markdownText(alert.getTitle(), alert.getContent());
        }
        return result;
    }
}

