/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.template.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dolphinscheduler.alert.template.AlertTemplate;
import org.apache.dolphinscheduler.alert.utils.JSONUtils;
import org.apache.dolphinscheduler.common.enums.ShowType;
import org.apache.dolphinscheduler.common.utils.Preconditions;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHTMLTemplate
implements AlertTemplate {
    public static final Logger logger = LoggerFactory.getLogger(DefaultHTMLTemplate.class);

    @Override
    public String getMessageFromTemplate(String content, ShowType showType, boolean showAll) {
        switch (showType) {
            case TABLE: {
                return this.getTableTypeMessage(content, showAll);
            }
            case TEXT: {
                return this.getTextTypeMessage(content, showAll);
            }
        }
        throw new IllegalArgumentException(String.format("not support showType: %s in DefaultHTMLTemplate", showType));
    }

    private String getTableTypeMessage(String content, boolean showAll) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            List<LinkedHashMap> mapItemsList = JSONUtils.toList(content, LinkedHashMap.class);
            if (!showAll && mapItemsList.size() > 1000) {
                mapItemsList = mapItemsList.subList(0, 1000);
            }
            StringBuilder contents = new StringBuilder(200);
            boolean flag = true;
            String title = "";
            for (LinkedHashMap mapItems : mapItemsList) {
                Set entries = mapItems.entrySet();
                Iterator iterator = entries.iterator();
                StringBuilder t = new StringBuilder("<tr>");
                StringBuilder cs = new StringBuilder("<tr>");
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    t.append("<th>").append((String)entry.getKey()).append("</th>");
                    cs.append("<td>").append(String.valueOf(entry.getValue())).append("</td>");
                }
                t.append("</tr>");
                cs.append("</tr>");
                if (flag) {
                    title = t.toString();
                }
                flag = false;
                contents.append((CharSequence)cs);
            }
            return this.getMessageFromHtmlTemplate(title, contents.toString());
        }
        return content;
    }

    private String getTextTypeMessage(String content, boolean showAll) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            List<String> list;
            try {
                list = JSONUtils.toList(content, String.class);
            }
            catch (Exception e) {
                logger.error("json format exception", (Throwable)e);
                return null;
            }
            StringBuilder contents = new StringBuilder(100);
            for (String str : list) {
                contents.append("<tr>");
                contents.append("<td>").append(str).append("</td>");
                contents.append("</tr>");
            }
            return this.getMessageFromHtmlTemplate(null, contents.toString());
        }
        return content;
    }

    private String getMessageFromHtmlTemplate(String title, String content) {
        Preconditions.checkNotNull((Object)content);
        String htmlTableThead = StringUtils.isEmpty((CharSequence)title) ? "" : String.format("<thead>%s</thead>\n", title);
        return "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN' 'http://www.w3.org/TR/html4/loose.dtd'><html><head><title>dolphinscheduler</title><meta name='Keywords' content=''><meta name='Description' content=''><style type=\"text/css\">table {margin-top:0px;padding-top:0px;border:1px solid;font-size: 14px;color: #333333;border-width: 1px;border-color: #666666;border-collapse: collapse;}table th {border-width: 1px;padding: 8px;border-style: solid;border-color: #666666;background-color: #dedede;text-align: left;}table td {border-width: 1px;padding: 8px;border-style: solid;border-color: #666666;background-color: #ffffff;text-align: left;}</style></head><body style=\"margin:0;padding:0\"><table border=\"1px\" cellpadding=\"5px\" cellspacing=\"-10px\"> " + htmlTableThead + content + "</table></body></html>";
    }
}

