/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.plugin.PluginManager;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.api.AlertPlugin;
import org.apache.dolphinscheduler.plugin.model.AlertData;
import org.apache.dolphinscheduler.plugin.model.AlertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertSender {
    private static final Logger logger = LoggerFactory.getLogger(AlertSender.class);
    private List<Alert> alertList;
    private AlertDao alertDao;
    private PluginManager pluginManager;

    public AlertSender() {
    }

    public AlertSender(List<Alert> alertList, AlertDao alertDao, PluginManager pluginManager) {
        this.alertList = alertList;
        this.alertDao = alertDao;
        this.pluginManager = pluginManager;
    }

    public void run() {
        Map retMaps = null;
        for (Alert alert : this.alertList) {
            List users = this.alertDao.listUserByAlertgroupId(alert.getAlertGroupId());
            ArrayList<String> receviersList = new ArrayList<String>();
            for (User user : users) {
                receviersList.add(user.getEmail());
            }
            AlertData alertData = new AlertData();
            alertData.setId(alert.getId()).setAlertGroupId(alert.getAlertGroupId()).setContent(alert.getContent()).setLog(alert.getLog()).setReceivers(alert.getReceivers()).setReceiversCc(alert.getReceiversCc()).setShowType(alert.getShowType().getDescp()).setTitle(alert.getTitle());
            AlertInfo alertInfo = new AlertInfo();
            alertInfo.setAlertData(alertData);
            alertInfo.addProp("receivers", receviersList);
            AlertPlugin emailPlugin = this.pluginManager.findOne("email");
            retMaps = emailPlugin.process(alertInfo);
            if (retMaps == null) {
                this.alertDao.updateAlert(AlertStatus.EXECUTION_FAILURE, "alert send error", alert.getId());
                logger.info("alert send error : return value is null");
                continue;
            }
            if (!Boolean.parseBoolean(String.valueOf(retMaps.get("status")))) {
                this.alertDao.updateAlert(AlertStatus.EXECUTION_FAILURE, String.valueOf(retMaps.get("message")), alert.getId());
                logger.info("alert send error : {}", retMaps.get("message"));
                continue;
            }
            this.alertDao.updateAlert(AlertStatus.EXECUTION_SUCCESS, (String)retMaps.get("message"), alert.getId());
            logger.info("alert send success");
        }
    }
}

