/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.alert.manager.EmailManager;
import org.apache.dolphinscheduler.alert.manager.EnterpriseWeChatManager;
import org.apache.dolphinscheduler.alert.utils.EnterpriseWeChatUtils;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.plugin.api.AlertPlugin;
import org.apache.dolphinscheduler.plugin.model.AlertData;
import org.apache.dolphinscheduler.plugin.model.AlertInfo;
import org.apache.dolphinscheduler.plugin.model.PluginName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAlertPlugin
implements AlertPlugin {
    private static final Logger logger = LoggerFactory.getLogger(EmailAlertPlugin.class);
    private PluginName pluginName = new PluginName();
    private static final EmailManager emailManager = new EmailManager();
    private static final EnterpriseWeChatManager weChatManager = new EnterpriseWeChatManager();

    public EmailAlertPlugin() {
        this.pluginName.setEnglish("email");
        this.pluginName.setChinese("\u90ae\u4ef6");
    }

    public String getId() {
        return "email";
    }

    public PluginName getName() {
        return this.pluginName;
    }

    public Map<String, Object> process(AlertInfo info) {
        Map<Object, Object> retMaps = new HashMap<String, String>();
        AlertData alert = info.getAlertData();
        List receviersList = (List)info.getProp("receivers");
        String receivers = alert.getReceivers();
        if (StringUtils.isNotEmpty((CharSequence)receivers)) {
            String[] splits = receivers.split(",");
            receviersList.addAll(Arrays.asList(splits));
        }
        ArrayList<String> receviersCcList = new ArrayList<String>();
        String receiversCc = alert.getReceiversCc();
        if (StringUtils.isNotEmpty((CharSequence)receiversCc)) {
            String[] splits = receiversCc.split(",");
            receviersCcList.addAll(Arrays.asList(splits));
        }
        if (CollectionUtils.isEmpty((Collection)receviersList) && CollectionUtils.isEmpty(receviersCcList)) {
            logger.warn("alert send error : At least one receiver address required");
            retMaps.put("status", "false");
            retMaps.put("message", "execution failure,At least one receiver address required.");
            return retMaps;
        }
        retMaps = emailManager.send(receviersList, receviersCcList, alert.getTitle(), alert.getContent(), alert.getShowType());
        if (retMaps == null) {
            retMaps = new HashMap();
            retMaps.put("message", "alert send error.");
            retMaps.put("status", "false");
            logger.info("alert send error : {}", retMaps.get("message"));
            return retMaps;
        }
        boolean status = Boolean.parseBoolean(String.valueOf(retMaps.get("status")));
        if (status) {
            logger.info("alert send success");
            retMaps.put("message", "email send success.");
            if (EnterpriseWeChatUtils.isEnable()) {
                logger.info("Enterprise WeChat is enable!");
                try {
                    String token = EnterpriseWeChatUtils.getToken();
                    weChatManager.send(info, token);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            retMaps.put("message", "alert send error.");
            logger.info("alert send error : {}", retMaps.get("message"));
        }
        return retMaps;
    }
}

