/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.manager;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.alert.utils.EnterpriseWeChatUtils;
import org.apache.dolphinscheduler.plugin.model.AlertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseWeChatManager {
    private static final Logger logger = LoggerFactory.getLogger(EnterpriseWeChatManager.class);

    public Map<String, Object> send(AlertInfo alertInfo, String token) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("status", false);
        String agentId = EnterpriseWeChatUtils.ENTERPRISE_WE_CHAT_AGENT_ID;
        String users = EnterpriseWeChatUtils.ENTERPRISE_WE_CHAT_USERS;
        List<String> userList = Arrays.asList(users.split(","));
        logger.info("send message {}", (Object)alertInfo.getAlertData().getTitle());
        String msg = EnterpriseWeChatUtils.makeUserSendMsg(userList, agentId, EnterpriseWeChatUtils.markdownByAlert(alertInfo.getAlertData()));
        try {
            EnterpriseWeChatUtils.sendEnterpriseWeChat("UTF-8", msg, token);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        retMap.put("status", true);
        return retMap;
    }
}

