/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import java.util.List;
import org.apache.dolphinscheduler.alert.plugin.EmailAlertPlugin;
import org.apache.dolphinscheduler.alert.runner.AlertSender;
import org.apache.dolphinscheduler.alert.utils.PropertyUtils;
import org.apache.dolphinscheduler.common.plugin.FilePluginManager;
import org.apache.dolphinscheduler.common.plugin.PluginManager;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.DaoFactory;
import org.apache.dolphinscheduler.plugin.api.AlertPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertServer {
    private static final Logger logger = LoggerFactory.getLogger(AlertServer.class);
    private AlertDao alertDao = (AlertDao)DaoFactory.getDaoInstance(AlertDao.class);
    private AlertSender alertSender;
    private static AlertServer instance;
    private FilePluginManager alertPluginManager = new FilePluginManager(PropertyUtils.getString("plugin.dir"), whitePrefixes, excludePrefixes);
    private static final String[] whitePrefixes;
    private static final String[] excludePrefixes;

    public AlertServer() {
        this.alertPluginManager.addPlugin((AlertPlugin)new EmailAlertPlugin());
    }

    public static synchronized AlertServer getInstance() {
        if (null == instance) {
            instance = new AlertServer();
        }
        return instance;
    }

    public void start() {
        logger.info("alert server ready start ");
        while (Stopper.isRunning()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            List alerts = this.alertDao.listWaitExecutionAlert();
            this.alertSender = new AlertSender(alerts, this.alertDao, (PluginManager)this.alertPluginManager);
            this.alertSender.run();
        }
    }

    public static void main(String[] args) {
        AlertServer alertServer = AlertServer.getInstance();
        alertServer.start();
    }

    static {
        whitePrefixes = new String[]{"org.apache.dolphinscheduler.plugin.utils."};
        excludePrefixes = new String[]{"org.apache.dolphinscheduler.plugin.", "ch.qos.logback.", "org.slf4j."};
    }
}

