/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.normalizers;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOtherException;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.NumericOidSyntaxChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameOrNumericIdNormalizer
extends Normalizer {
    private NumericOidSyntaxChecker checker = new NumericOidSyntaxChecker();
    private SchemaManager schemaManager;
    public static final NameOrNumericIdNormalizer INSTANCE = new NameOrNumericIdNormalizer();

    public NameOrNumericIdNormalizer() {
        super("1.3.6.1.4.1.18060.0.4.0.1.0");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        if (value == null) {
            return null;
        }
        String strValue = value.getString();
        if (strValue.length() == 0) {
            return new StringValue("");
        }
        if (this.checker.isValidSyntax(strValue)) {
            return value;
        }
        String oid = this.schemaManager.getRegistries().getOid(strValue);
        if (oid != null) {
            return new StringValue(oid);
        }
        throw new LdapOtherException(I18n.err((I18n)I18n.ERR_04225, (Object[])new Object[]{value}));
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        if (this.checker.isValidSyntax(value)) {
            return value;
        }
        String oid = this.schemaManager.getRegistries().getOid(value);
        if (oid != null) {
            return oid;
        }
        throw new LdapOtherException(I18n.err((I18n)I18n.ERR_04226, (Object[])new Object[]{value}));
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

