/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.DescriptionUtils;
import org.apache.directory.shared.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.Registries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectClass
extends AbstractSchemaObject {
    private ObjectClassTypeEnum objectClassType = ObjectClassTypeEnum.STRUCTURAL;
    private List<String> superiorOids;
    private List<ObjectClass> superiors;
    private List<String> mayAttributeTypeOids = new ArrayList<String>();
    private List<AttributeType> mayAttributeTypes;
    private List<String> mustAttributeTypeOids = new ArrayList<String>();
    private List<AttributeType> mustAttributeTypes;

    public ObjectClass(String oid) {
        super(SchemaObjectType.OBJECT_CLASS, oid);
        this.superiorOids = new ArrayList<String>();
        this.mayAttributeTypes = new ArrayList<AttributeType>();
        this.mustAttributeTypes = new ArrayList<AttributeType>();
        this.superiors = new ArrayList<ObjectClass>();
        this.objectClassType = ObjectClassTypeEnum.STRUCTURAL;
    }

    @Override
    public void removeFromRegistries(List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            ObjectClassRegistry objectClassRegistry = registries.getObjectClassRegistry();
            objectClassRegistry.unregisterDescendants(this, this.superiors);
            if (this.mayAttributeTypes != null) {
                for (AttributeType may : this.mayAttributeTypes) {
                    registries.delReference(this, may);
                }
            }
            if (this.mustAttributeTypes != null) {
                for (AttributeType must : this.mustAttributeTypes) {
                    registries.delReference(this, must);
                }
            }
            if (this.superiors != null) {
                for (ObjectClass superior : this.superiors) {
                    registries.delReference(this, superior);
                }
            }
        }
    }

    public List<String> getMayAttributeTypeOids() {
        return this.mayAttributeTypeOids;
    }

    public List<AttributeType> getMayAttributeTypes() {
        return this.mayAttributeTypes;
    }

    public void addMayAttributeTypeOids(String ... oids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            for (String oid : oids) {
                this.mayAttributeTypeOids.add(oid);
            }
        }
    }

    public void addMayAttributeTypes(AttributeType ... attributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            for (AttributeType attributeType : attributeTypes) {
                if (this.mayAttributeTypeOids.contains(attributeType.getOid())) continue;
                this.mayAttributeTypes.add(attributeType);
                this.mayAttributeTypeOids.add(attributeType.getOid());
            }
        }
    }

    public void setMayAttributeTypeOids(List<String> mayAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mayAttributeTypeOids = mayAttributeTypeOids;
        }
    }

    public void setMayAttributeTypes(List<AttributeType> mayAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mayAttributeTypes = mayAttributeTypes;
            this.mayAttributeTypeOids.clear();
            for (AttributeType may : mayAttributeTypes) {
                this.mayAttributeTypeOids.add(may.getOid());
            }
        }
    }

    public void updateMayAttributeTypes(List<AttributeType> mayAttributeTypes) {
        this.mayAttributeTypes.clear();
        this.mayAttributeTypes.addAll(mayAttributeTypes);
        this.mayAttributeTypeOids.clear();
        for (AttributeType may : mayAttributeTypes) {
            this.mayAttributeTypeOids.add(may.getOid());
        }
    }

    public List<String> getMustAttributeTypeOids() {
        return this.mustAttributeTypeOids;
    }

    public List<AttributeType> getMustAttributeTypes() {
        return this.mustAttributeTypes;
    }

    public void addMustAttributeTypeOids(String ... oids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            for (String oid : oids) {
                this.mustAttributeTypeOids.add(oid);
            }
        }
    }

    public void addMustAttributeTypes(AttributeType ... attributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            for (AttributeType attributeType : attributeTypes) {
                if (this.mustAttributeTypeOids.contains(attributeType.getOid())) continue;
                this.mustAttributeTypes.add(attributeType);
                this.mustAttributeTypeOids.add(attributeType.getOid());
            }
        }
    }

    public void setMustAttributeTypeOids(List<String> mustAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mustAttributeTypeOids = mustAttributeTypeOids;
        }
    }

    public void setMustAttributeTypes(List<AttributeType> mustAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mustAttributeTypes = mustAttributeTypes;
            this.mustAttributeTypeOids.clear();
            for (AttributeType may : mustAttributeTypes) {
                this.mustAttributeTypeOids.add(may.getOid());
            }
        }
    }

    public void updateMustAttributeTypes(List<AttributeType> mustAttributeTypes) {
        this.mustAttributeTypes.clear();
        this.mustAttributeTypes.addAll(mustAttributeTypes);
        this.mustAttributeTypeOids.clear();
        for (AttributeType must : mustAttributeTypes) {
            this.mustAttributeTypeOids.add(must.getOid());
        }
    }

    public List<ObjectClass> getSuperiors() {
        return this.superiors;
    }

    public List<String> getSuperiorOids() {
        return this.superiorOids;
    }

    public void addSuperiorOids(String ... oids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            for (String oid : oids) {
                if (this.superiorOids.contains(oid)) continue;
                this.superiorOids.add(oid);
            }
        }
    }

    public void addSuperior(ObjectClass ... objectClasses) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            for (ObjectClass objectClass : objectClasses) {
                if (this.superiorOids.contains(objectClass.getOid())) continue;
                this.superiorOids.add(objectClass.getOid());
                this.superiors.add(objectClass);
            }
        }
    }

    public void setSuperiors(List<ObjectClass> superiors) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.superiors = superiors;
            this.superiorOids.clear();
            for (ObjectClass oc : superiors) {
                this.superiorOids.add(oc.getOid());
            }
        }
    }

    public void updateSuperiors(List<ObjectClass> superiors) {
        this.superiors.clear();
        this.superiors.addAll(superiors);
        this.superiorOids.clear();
        for (ObjectClass oc : superiors) {
            this.superiorOids.add(oc.getOid());
        }
    }

    public void setSuperiorOids(List<String> superiorOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.superiorOids = superiorOids;
        }
    }

    public ObjectClassTypeEnum getType() {
        return this.objectClassType;
    }

    public void setType(ObjectClassTypeEnum objectClassType) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.objectClassType = objectClassType;
        }
    }

    public boolean isStructural() {
        return this.objectClassType == ObjectClassTypeEnum.STRUCTURAL;
    }

    public boolean isAbstract() {
        return this.objectClassType == ObjectClassTypeEnum.ABSTRACT;
    }

    public boolean isAuxiliary() {
        return this.objectClassType == ObjectClassTypeEnum.AUXILIARY;
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public ObjectClass copy() {
        ObjectClass copy = new ObjectClass(this.oid);
        copy.copy(this);
        copy.objectClassType = this.objectClassType;
        copy.superiorOids = new ArrayList<String>();
        for (String oid : this.superiorOids) {
            copy.superiorOids.add(oid);
        }
        copy.superiors = new ArrayList<ObjectClass>();
        copy.mayAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.mayAttributeTypeOids) {
            copy.mayAttributeTypeOids.add(oid);
        }
        copy.mayAttributeTypes = new ArrayList<AttributeType>();
        copy.mustAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.mustAttributeTypeOids) {
            copy.mustAttributeTypeOids.add(oid);
        }
        copy.mustAttributeTypes = new ArrayList<AttributeType>();
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ObjectClass)) {
            return false;
        }
        ObjectClass that = (ObjectClass)o;
        if (this.objectClassType != that.objectClassType) {
            return false;
        }
        if (this.superiorOids.size() != that.superiorOids.size()) {
            return false;
        }
        for (String string : this.superiorOids) {
            if (that.superiorOids.contains(string)) continue;
            return false;
        }
        for (String string : that.superiorOids) {
            if (this.superiorOids.contains(string)) continue;
            return false;
        }
        if (this.superiors.size() != that.superiors.size()) {
            return false;
        }
        for (ObjectClass objectClass : this.superiors) {
            if (that.superiors.contains(objectClass)) continue;
            return false;
        }
        for (ObjectClass objectClass : that.superiors) {
            if (this.superiors.contains(objectClass)) continue;
            return false;
        }
        if (this.mayAttributeTypeOids.size() != that.mayAttributeTypeOids.size()) {
            return false;
        }
        for (String string : this.mayAttributeTypeOids) {
            if (that.mayAttributeTypeOids.contains(string)) continue;
            return false;
        }
        for (String string : that.mayAttributeTypeOids) {
            if (this.mayAttributeTypeOids.contains(string)) continue;
            return false;
        }
        if (this.mayAttributeTypes.size() != that.mayAttributeTypes.size()) {
            return false;
        }
        for (AttributeType attributeType : this.mayAttributeTypes) {
            if (that.mayAttributeTypes.contains(attributeType)) continue;
            return false;
        }
        for (AttributeType attributeType : that.mayAttributeTypes) {
            if (this.mayAttributeTypes.contains(attributeType)) continue;
            return false;
        }
        if (this.mustAttributeTypeOids.size() != that.mustAttributeTypeOids.size()) {
            return false;
        }
        for (String string : this.mustAttributeTypeOids) {
            if (that.mustAttributeTypeOids.contains(string)) continue;
            return false;
        }
        for (String string : that.mustAttributeTypeOids) {
            if (this.mustAttributeTypeOids.contains(string)) continue;
            return false;
        }
        if (this.mustAttributeTypes.size() != that.mustAttributeTypes.size()) {
            return false;
        }
        for (AttributeType attributeType : this.mustAttributeTypes) {
            if (that.mustAttributeTypes.contains(attributeType)) continue;
            return false;
        }
        for (AttributeType attributeType : that.mustAttributeTypes) {
            if (this.mustAttributeTypes.contains(attributeType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.mayAttributeTypes.clear();
        this.mayAttributeTypeOids.clear();
        this.mustAttributeTypes.clear();
        this.mustAttributeTypeOids.clear();
        this.superiors.clear();
        this.superiorOids.clear();
    }
}

