/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.SchemaObject;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.registries.Registries;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaObject
implements SchemaObject,
Serializable {
    private static final long serialVersionUID = 2L;
    protected String oid;
    protected List<String> names;
    protected boolean isEnabled = true;
    protected boolean isReadOnly = false;
    protected boolean isObsolete = false;
    protected String description;
    protected String specification;
    protected String schemaName;
    protected SchemaObjectType objectType;
    protected Map<String, List<String>> extensions;
    protected volatile boolean locked;
    private int h;

    protected AbstractSchemaObject(SchemaObjectType objectType, String oid) {
        this.objectType = objectType;
        this.oid = oid;
        this.extensions = new HashMap<String, List<String>>();
        this.names = new ArrayList<String>();
    }

    protected AbstractSchemaObject(SchemaObjectType objectType) {
        this.objectType = objectType;
        this.extensions = new HashMap<String, List<String>>();
        this.names = new ArrayList<String>();
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public void setOid(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.oid = oid;
    }

    @Override
    public List<String> getNames() {
        if (this.names != null) {
            return Collections.unmodifiableList(this.names);
        }
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        if (this.names != null && this.names.size() != 0) {
            return this.names.get(0);
        }
        return this.oid;
    }

    @Override
    public void addToRegistries(List<Throwable> errors, Registries registries) throws LdapException {
    }

    @Override
    public void removeFromRegistries(List<Throwable> errors, Registries registries) throws LdapException {
    }

    @Override
    public void setRegistries(Registries registries) {
    }

    @Override
    public void addName(String ... namesToAdd) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            HashSet<String> lowerNames = new HashSet<String>();
            for (String name : this.names) {
                lowerNames.add(Strings.toLowerCase((String)name));
            }
            for (String name : namesToAdd) {
                String lowerName;
                if (name == null || lowerNames.contains(lowerName = Strings.toLowerCase((String)name))) continue;
                this.names.add(name);
                lowerNames.add(lowerName);
            }
        }
    }

    @Override
    public void setNames(List<String> names) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (names == null) {
            return;
        }
        if (!this.isReadOnly) {
            this.names = new ArrayList<String>(names.size());
            for (String name : names) {
                if (name == null) continue;
                this.names.add(name);
            }
        }
    }

    public void setNames(String ... names) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (names == null) {
            return;
        }
        if (!this.isReadOnly) {
            this.names.clear();
            for (String name : names) {
                if (name == null) continue;
                this.names.add(name);
            }
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.description = description;
        }
    }

    @Override
    public String getSpecification() {
        return this.specification;
    }

    @Override
    public void setSpecification(String specification) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.specification = specification;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isDisabled() {
        return !this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isReadOnly) {
            this.isEnabled = enabled;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.isReadOnly = readOnly;
    }

    @Override
    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Override
    public void setObsolete(boolean obsolete) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.isObsolete = obsolete;
        }
    }

    @Override
    public Map<String, List<String>> getExtensions() {
        return this.extensions;
    }

    @Override
    public void addExtension(String key, String ... values) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            ArrayList<String> valueList = new ArrayList<String>();
            for (String value : values) {
                valueList.add(value);
            }
            this.extensions.put(key, valueList);
        }
    }

    @Override
    public void addExtension(String key, List<String> values) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.extensions.put(key, values);
        }
    }

    @Override
    public void setExtensions(Map<String, List<String>> extensions) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly && extensions != null) {
            this.extensions = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : extensions.entrySet()) {
                ArrayList<String> values = new ArrayList<String>();
                for (String value : entry.getValue()) {
                    values.add(value);
                }
                this.extensions.put(entry.getKey(), values);
            }
        }
    }

    @Override
    public SchemaObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public void setSchemaName(String schemaName) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.schemaName = schemaName;
        }
    }

    @Override
    public final int hashCode() {
        return this.h;
    }

    @Override
    public boolean equals(Object o1) {
        if (this == o1) {
            return true;
        }
        if (!(o1 instanceof AbstractSchemaObject)) {
            return false;
        }
        AbstractSchemaObject that = (AbstractSchemaObject)o1;
        if (!this.compareOid(this.oid, that.oid)) {
            return false;
        }
        if (this.names == null) {
            if (that.names != null) {
                return false;
            }
        } else {
            if (that.names == null) {
                return false;
            }
            int nbNames = 0;
            for (String name : this.names) {
                if (!that.names.contains(name)) {
                    return false;
                }
                ++nbNames;
            }
            if (nbNames != this.names.size()) {
                return false;
            }
        }
        if (this.schemaName == null ? that.schemaName != null : !this.schemaName.equalsIgnoreCase(that.schemaName)) {
            return false;
        }
        if (this.objectType != that.objectType) {
            return false;
        }
        if (this.extensions != null) {
            if (that.extensions == null) {
                return false;
            }
            for (String key : this.extensions.keySet()) {
                if (!that.extensions.containsKey(key)) {
                    return false;
                }
                List<String> thisValues = this.extensions.get(key);
                List<String> thatValues = that.extensions.get(key);
                if (thisValues != null) {
                    if (thatValues == null) {
                        return false;
                    }
                    if (thisValues.size() == thatValues.size()) continue;
                    return false;
                }
                if (thatValues == null) continue;
                return false;
            }
        } else if (that.extensions != null) {
            return false;
        }
        if (this.isEnabled != that.isEnabled) {
            return false;
        }
        if (this.isObsolete != that.isObsolete) {
            return false;
        }
        if (this.isReadOnly != that.isReadOnly) {
            return false;
        }
        if (this.description == null) {
            return that.description == null;
        }
        return this.description.equalsIgnoreCase(that.description);
    }

    @Override
    public void registerOid(SchemaObject schemaObject, Registries registries) throws LdapException {
        registries.getGlobalOidRegistry().register(schemaObject);
    }

    @Override
    public abstract SchemaObject copy();

    protected boolean compareOid(String oid1, String oid2) {
        if (oid1 == null) {
            return oid2 == null;
        }
        return oid1.equals(oid2);
    }

    @Override
    public SchemaObject copy(SchemaObject original) {
        this.description = original.getDescription();
        this.isEnabled = original.isEnabled();
        this.isObsolete = original.isObsolete();
        this.isReadOnly = original.isReadOnly();
        this.names = new ArrayList<String>();
        for (String name : original.getNames()) {
            this.names.add(name);
        }
        this.extensions = new HashMap<String, List<String>>();
        for (String key : original.getExtensions().keySet()) {
            List<String> extensionValues = original.getExtensions().get(key);
            ArrayList<String> cloneExtension = new ArrayList<String>();
            for (String value : extensionValues) {
                cloneExtension.add(value);
            }
            this.extensions.put(key, cloneExtension);
        }
        this.schemaName = original.getSchemaName();
        this.specification = original.getSpecification();
        return this;
    }

    @Override
    public void clear() {
        for (String extension : this.extensions.keySet()) {
            List<String> extensionList = this.extensions.get(extension);
            extensionList.clear();
        }
        this.extensions.clear();
        this.names.clear();
    }

    public void unlock() {
        this.locked = false;
    }

    @Override
    public final void lock() {
        if (this.locked) {
            return;
        }
        this.h = 37;
        this.h += this.h * 17 + this.oid.hashCode();
        this.h += this.h * 17 + this.objectType.getValue();
        if (this.names != null && this.names.size() != 0) {
            for (String name : this.names) {
                this.h += this.h * 17 + name.hashCode();
            }
        }
        if (this.schemaName != null) {
            this.h += this.h * 17 + this.schemaName.hashCode();
        }
        this.h += this.h * 17 + (this.isEnabled ? 1 : 0);
        this.h += this.h * 17 + (this.isReadOnly ? 1 : 0);
        if (this.description != null) {
            this.h += this.h * 17 + this.description.hashCode();
        }
        for (String key : this.extensions.keySet()) {
            this.h += this.h * 17 + key.hashCode();
            List<String> values = this.extensions.get(key);
            if (values == null) continue;
            for (String value : values) {
                this.h += this.h * 17 + value.hashCode();
            }
        }
        this.locked = true;
    }
}

