/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.ldif;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.AttributeUtils;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.ldif.ChangeType;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LdifRevertor {
    public static final boolean DELETE_OLD_RDN = true;
    public static final boolean KEEP_OLD_RDN = false;

    private LdifRevertor() {
    }

    public static LdifEntry reverseAdd(Dn dn) {
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Delete);
        entry.setDn(dn);
        return entry;
    }

    public static LdifEntry reverseDel(Dn dn, Entry deletedEntry) throws LdapException {
        LdifEntry entry = new LdifEntry();
        entry.setDn(dn);
        entry.setChangeType(ChangeType.Add);
        for (Attribute attribute : deletedEntry) {
            entry.addAttribute(attribute);
        }
        return entry;
    }

    public static LdifEntry reverseModify(Dn dn, List<Modification> forwardModifications, Entry modifiedEntry) throws LdapException {
        Entry clonedEntry = modifiedEntry.clone();
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Modify);
        entry.setDn(dn);
        ArrayList<DefaultModification> reverseModifications = new ArrayList<DefaultModification>();
        block5: for (Modification modification : forwardModifications) {
            switch (modification.getOperation()) {
                case ADD_ATTRIBUTE: {
                    Attribute mod = modification.getAttribute();
                    Attribute previous = clonedEntry.get(mod.getId());
                    if (mod.equals(previous)) continue block5;
                    DefaultModification reverseModification = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    DefaultModification reverseModification;
                    Attribute mod = modification.getAttribute();
                    Attribute previous = clonedEntry.get(mod.getId());
                    if (previous == null) continue block5;
                    if (mod.get() == null) {
                        reverseModification = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, previous);
                        reverseModifications.add(0, reverseModification);
                        break;
                    }
                    reverseModification = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    DefaultModification reverseModification;
                    Attribute mod = modification.getAttribute();
                    Attribute previous = clonedEntry.get(mod.getId());
                    if (mod.get() == null && previous == null) {
                        reverseModification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute(mod.getId()));
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (mod.get() == null) {
                        reverseModification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, previous);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (previous == null) {
                        DefaultAttribute emptyAttribute = new DefaultAttribute(mod.getId());
                        reverseModification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, emptyAttribute);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    reverseModification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, previous);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
            }
            AttributeUtils.applyModification(clonedEntry, modification);
        }
        if (reverseModifications.size() == 0) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_12073, (Object[])new Object[]{forwardModifications}));
        }
        for (Modification modification : reverseModifications) {
            entry.addModification(modification);
        }
        return entry;
    }

    public static LdifEntry reverseMove(Dn newSuperiorDn, Dn modifiedDn) throws LdapException {
        LdifEntry entry = new LdifEntry();
        Dn currentParent = null;
        Rdn currentRdn = null;
        Dn newDn = null;
        if (newSuperiorDn == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_12074, (Object[])new Object[0]));
        }
        if (modifiedDn == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_12075, (Object[])new Object[0]));
        }
        if (modifiedDn.size() == 0) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_12076, (Object[])new Object[0]));
        }
        currentParent = modifiedDn;
        currentRdn = currentParent.getRdn();
        currentParent = currentParent.getParent();
        newDn = newSuperiorDn;
        newDn = newDn.add(modifiedDn.getRdn());
        entry.setChangeType(ChangeType.ModDn);
        entry.setDn(newDn);
        entry.setNewRdn(currentRdn.getName());
        entry.setNewSuperior(currentParent.getName());
        entry.setDeleteOldRdn(false);
        return entry;
    }

    private static LdifEntry revertEntry(Entry entry, Dn newDn, Dn newSuperior, Rdn oldRdn, Rdn newRdn) throws LdapInvalidDnException {
        LdifEntry reverted = new LdifEntry();
        reverted.setChangeType(ChangeType.ModRdn);
        if (newSuperior != null) {
            Dn restoredDn = newSuperior.add(newRdn);
            reverted.setDn(restoredDn);
        } else {
            reverted.setDn(newDn);
        }
        reverted.setNewRdn(oldRdn.getName());
        boolean keepOldRdn = entry.contains(newRdn.getNormType(), newRdn.getNormValue());
        reverted.setDeleteOldRdn(!keepOldRdn);
        if (newSuperior != null) {
            Dn oldSuperior = entry.getDn();
            oldSuperior = oldSuperior.getParent();
            reverted.setNewSuperior(oldSuperior.getName());
        }
        return reverted;
    }

    private static LdifEntry generateModify(Dn parentDn, Entry entry, Rdn oldRdn, Rdn newRdn) {
        LdifEntry restored = new LdifEntry();
        restored.setChangeType(ChangeType.Modify);
        restored.setDn(parentDn);
        for (Ava ava : newRdn) {
            if (entry.contains(ava.getNormType(), ava.getNormValue().getString()) || ava.getNormType().equals(oldRdn.getNormType()) && ava.getNormValue().getString().equals(oldRdn.getNormValue().getString())) continue;
            DefaultModification modification = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, new DefaultAttribute(ava.getType(), ava.getValue().getString()));
            restored.addModification(modification);
        }
        return restored;
    }

    private static LdifEntry generateReverted(Dn newSuperior, Rdn newRdn, Dn newDn, Rdn oldRdn, boolean deleteOldRdn) throws LdapInvalidDnException {
        LdifEntry reverted = new LdifEntry();
        reverted.setChangeType(ChangeType.ModRdn);
        if (newSuperior != null) {
            Dn restoredDn = newSuperior.add(newRdn);
            reverted.setDn(restoredDn);
        } else {
            reverted.setDn(newDn);
        }
        reverted.setNewRdn(oldRdn.getName());
        if (newSuperior != null) {
            Dn oldSuperior = newDn;
            oldSuperior = oldSuperior.getParent();
            reverted.setNewSuperior(oldSuperior.getName());
        }
        reverted.setDeleteOldRdn(deleteOldRdn);
        return reverted;
    }

    public static List<LdifEntry> reverseRename(Entry entry, Rdn newRdn, boolean deleteOldRdn) throws LdapInvalidDnException {
        return LdifRevertor.reverseMoveAndRename(entry, null, newRdn, deleteOldRdn);
    }

    public static List<LdifEntry> reverseMoveAndRename(Entry entry, Dn newSuperior, Rdn newRdn, boolean deleteOldRdn) throws LdapInvalidDnException {
        Dn parentDn = entry.getDn();
        Dn newDn = null;
        if (newRdn == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_12077, (Object[])new Object[0]));
        }
        if (parentDn == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_12078, (Object[])new Object[0]));
        }
        if (parentDn.size() == 0) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_12079, (Object[])new Object[0]));
        }
        parentDn = entry.getDn();
        Rdn oldRdn = parentDn.getRdn();
        newDn = parentDn;
        newDn = newDn.getParent();
        newDn = newDn.add(newRdn);
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>(1);
        LdifEntry reverted = new LdifEntry();
        if (newRdn.size() == 1) {
            reverted = LdifRevertor.revertEntry(entry, newDn, newSuperior, oldRdn, newRdn);
            entries.add(reverted);
        } else if (oldRdn.size() == 1) {
            LdifEntry restored;
            boolean overlapping = false;
            boolean existInEntry = false;
            for (Ava atav : newRdn) {
                if (atav.equals(oldRdn.getAva())) {
                    overlapping = true;
                    continue;
                }
                if (!entry.contains(atav.getNormType(), atav.getNormValue().getString())) continue;
                existInEntry = true;
            }
            if (overlapping) {
                if (existInEntry) {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                    entries.add(reverted);
                    restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                    entries.add(restored);
                } else {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                    entries.add(reverted);
                }
            } else if (existInEntry) {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                entries.add(reverted);
                restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                entries.add(restored);
            } else {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                entries.add(reverted);
            }
        } else {
            boolean overlapping = false;
            boolean existInEntry = false;
            HashSet<Ava> oldAtavs = new HashSet<Ava>();
            for (Ava atav : oldRdn) {
                oldAtavs.add(atav);
            }
            for (Ava atav : newRdn) {
                if (oldAtavs.contains(atav)) {
                    overlapping = true;
                    continue;
                }
                if (!entry.contains(atav.getNormType(), atav.getNormValue().getString())) continue;
                existInEntry = true;
            }
            if (overlapping) {
                if (existInEntry) {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                    entries.add(reverted);
                } else {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                    entries.add(reverted);
                }
            } else if (existInEntry) {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                entries.add(reverted);
                LdifEntry restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                entries.add(restored);
            } else {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                entries.add(reverted);
            }
        }
        return entries;
    }
}

