/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ShutdownDialog
extends JDialog {
    private static final long serialVersionUID = -6681747075037789868L;
    private JPanel jContentPane = null;
    private JPanel inputsPanel = null;
    private JPanel buttonsPanel = null;
    private JButton sendButton = null;
    private JButton cancelButton = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel = null;
    private JTextField timeOfflineField = null;
    private JLabel jLabel1 = null;
    private JTextField delayField = null;
    private boolean canceled = true;

    public ShutdownDialog() {
        this.initialize();
    }

    public boolean isSendCanceled() {
        return this.canceled;
    }

    public int getTimeOffline() {
        return Integer.parseInt(this.timeOfflineField.getText());
    }

    public int getDelay() {
        return Integer.parseInt(this.delayField.getText());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initialize() {
        this.setSize(248, 171);
        this.setTitle("Shutdown Parameters");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
            this.jContentPane.add((Component)this.getJPanel2(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.inputsPanel == null) {
            this.inputsPanel = new JPanel();
            this.inputsPanel.setLayout(null);
            this.inputsPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.inputsPanel.add((Component)this.getJPanel3(), null);
            this.inputsPanel.add((Component)this.getJPanel1(), null);
        }
        return this.inputsPanel;
    }

    private JPanel getJPanel2() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.add((Component)this.getJButton(), null);
            this.buttonsPanel.add((Component)this.getJButton2(), null);
        }
        return this.buttonsPanel;
    }

    private JButton getJButton() {
        if (this.sendButton == null) {
            this.sendButton = new JButton();
            this.sendButton.setText("Send");
            this.sendButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int timeOffline = 0;
                    try {
                        timeOffline = Integer.parseInt(ShutdownDialog.this.timeOfflineField.getText());
                        if (timeOffline > 720 || timeOffline < 0) {
                            JOptionPane.showMessageDialog(ShutdownDialog.this, "Time Offline is out of range: 0 ... 720", "Range Problem", 0);
                            ShutdownDialog.this.timeOfflineField.setText("");
                            return;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(ShutdownDialog.this, "The value for Time Offline is not a number", "Not a Number", 0);
                        ShutdownDialog.this.timeOfflineField.setText("");
                        return;
                    }
                    int delay = 0;
                    try {
                        delay = Integer.parseInt(ShutdownDialog.this.delayField.getText());
                        if (delay > 86400 || delay < 0) {
                            JOptionPane.showMessageDialog(ShutdownDialog.this, "Delay is out of range: 0 ... 86400", "Range Problem", 0);
                            ShutdownDialog.this.delayField.setText("");
                            return;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(ShutdownDialog.this, "Delay is not a number", "Not a Number", 0);
                        ShutdownDialog.this.delayField.setText("");
                        return;
                    }
                    ShutdownDialog.this.canceled = false;
                    ShutdownDialog.this.setVisible(false);
                    ShutdownDialog.this.dispose();
                }
            });
        }
        return this.sendButton;
    }

    private JButton getJButton2() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setSelected(true);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShutdownDialog.this.canceled = true;
                    ShutdownDialog.this.setVisible(false);
                    ShutdownDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getJPanel3() {
        if (this.jPanel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Minutes Offline: ");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BoxLayout(this.getJPanel3(), 0));
            this.jPanel.setBounds(new Rectangle(35, 28, 163, 16));
            this.jPanel.add((Component)this.jLabel, null);
            this.jPanel.add((Component)this.getJTextField(), null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Seconds Delay: ");
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BoxLayout(this.getJPanel1(), 0));
            this.jPanel1.setBounds(new Rectangle(42, 57, 156, 16));
            this.jPanel1.add((Component)this.jLabel1, null);
            this.jPanel1.add((Component)this.getJTextField1(), null);
        }
        return this.jPanel1;
    }

    private JTextField getJTextField() {
        if (this.timeOfflineField == null) {
            this.timeOfflineField = new JTextField();
        }
        return this.timeOfflineField;
    }

    private JTextField getJTextField1() {
        if (this.delayField == null) {
            this.delayField = new JTextField();
        }
        return this.delayField;
    }
}

