/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import javax.naming.ldap.Control;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.InternalControl;
import org.apache.directory.shared.ldap.message.InternalRequest;
import org.apache.directory.shared.ldap.message.InternalResultResponse;
import org.apache.directory.shared.ldap.message.InternalResultResponseRequest;
import org.apache.directory.shared.ldap.message.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LdapProtocolHandler
extends DemuxingIoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LdapProtocolHandler.class);
    private final LdapServer ldapServer;

    LdapProtocolHandler(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    public void sessionCreated(IoSession session) throws Exception {
        LdapSession ldapSession = new LdapSession(session);
        this.ldapServer.getLdapSessionManager().addLdapSession(ldapSession);
    }

    public void sessionClosed(IoSession session) {
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().removeLdapSession(session);
        this.cleanUpSession(ldapSession);
    }

    private void cleanUpSession(LdapSession ldapSession) {
        if (ldapSession == null) {
            LOG.warn("Null LdapSession given to cleanUpSession.");
            return;
        }
        LOG.debug("Cleaning the {} session", (Object)ldapSession);
        if (ldapSession != null) {
            ldapSession.abandonAllOutstandingRequests();
        }
        if (!ldapSession.getIoSession().isClosing() || ldapSession.getIoSession().isConnected()) {
            try {
                ldapSession.getIoSession().close(true);
            }
            catch (Throwable t) {
                LOG.warn("Failed to close IoSession for LdapSession.");
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        ExtendedRequestImpl req;
        if (message == SslFilter.SESSION_SECURED) {
            req = new ExtendedRequestImpl(0);
            req.setOid("1.3.6.1.4.1.1466.20037");
            req.setPayload("SECURED".getBytes("ISO-8859-1"));
            message = req;
        } else if (message == SslFilter.SESSION_UNSECURED) {
            req = new ExtendedRequestImpl(0);
            req.setOid("1.3.6.1.4.1.1466.20037");
            req.setPayload("UNSECURED".getBytes("ISO-8859-1"));
            message = req;
        }
        if (((InternalRequest)message).getControls().size() > 0 && message instanceof InternalResultResponseRequest) {
            req = (InternalResultResponseRequest)message;
            for (Control control1 : req.getControls().values()) {
                InternalControl control = (InternalControl)control1;
                if (!control.isCritical() || this.ldapServer.getSupportedControls().contains(control.getID())) continue;
                InternalResultResponse resp = req.getResultResponse();
                resp.getLdapResult().setErrorMessage("Unsupport critical control: " + control.getID());
                resp.getLdapResult().setResultCode(ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION);
                session.write((Object)resp);
                return;
            }
        }
        super.messageReceived(session, message);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        ResponseCarryingMessageException rcme;
        if (cause.getCause() instanceof ResponseCarryingMessageException && (rcme = (ResponseCarryingMessageException)cause.getCause()).getResponse() != null) {
            session.write((Object)rcme.getResponse());
            return;
        }
        LOG.warn("Unexpected exception forcing session to close: sending disconnect notice to client.", cause);
        session.write((Object)NoticeOfDisconnect.PROTOCOLERROR);
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().removeLdapSession(session);
        this.cleanUpSession(ldapSession);
        session.close(true);
    }
}

