/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;

public class PageHeader
implements BlockView {
    private static final short O_MAGIC = 0;
    private static final short O_NEXT = 2;
    private static final short O_PREV = 10;
    protected static final short SIZE = 18;
    protected BlockIo block;

    protected PageHeader(BlockIo block) {
        this.initialize(block);
        if (!this.magicOk()) {
            throw new Error("CRITICAL: page header magic for block " + block.getBlockId() + " not OK " + this.getMagic());
        }
    }

    PageHeader(BlockIo block, short type) {
        this.initialize(block);
        this.setType(type);
    }

    static PageHeader getView(BlockIo block) {
        BlockView view = block.getView();
        if (view != null && view instanceof PageHeader) {
            return (PageHeader)view;
        }
        return new PageHeader(block);
    }

    private void initialize(BlockIo block) {
        this.block = block;
        block.setView(this);
    }

    private boolean magicOk() {
        short magic = this.getMagic();
        return magic >= 4945 && magic <= 4949;
    }

    protected void paranoiaMagicOk() {
        if (!this.magicOk()) {
            throw new Error("CRITICAL: page header magic not OK " + this.getMagic());
        }
    }

    short getMagic() {
        return this.block.readShort(0);
    }

    long getNext() {
        this.paranoiaMagicOk();
        return this.block.readLong(2);
    }

    void setNext(long next) {
        this.paranoiaMagicOk();
        this.block.writeLong(2, next);
    }

    long getPrev() {
        this.paranoiaMagicOk();
        return this.block.readLong(10);
    }

    void setPrev(long prev) {
        this.paranoiaMagicOk();
        this.block.writeLong(10, prev);
    }

    void setType(short type) {
        this.block.writeShort(0, (short)(4945 + type));
    }
}

