/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ArrayTree<K> {
    private Comparator<K> comparator;
    private K[] array;
    private int size;
    private static final int INCREMENT = 16;

    public ArrayTree(Comparator<K> comparator) {
        this.comparator = comparator;
        this.array = new Object[16];
        this.size = 0;
    }

    public ArrayTree(Comparator<K> comparator, K[] array) {
        this.comparator = comparator;
        if (array != null) {
            int arraySize = this.size = array.length;
            if (this.size % 16 != 0) {
                arraySize += 16 - this.size % 16;
            }
            this.array = new Object[arraySize];
            System.arraycopy(array, 0, this.array, 0, this.size);
        }
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    public K insert(K key) {
        if (key == null) {
            return null;
        }
        K existing = this.find(key);
        if (existing != null) {
            return existing;
        }
        if (this.size == this.array.length) {
            Object[] newArray = new Object[this.size + 16];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
        this.array[this.size++] = key;
        Arrays.sort(this.array, 0, this.size, this.comparator);
        return null;
    }

    private void reduceArray() {
        if (this.array.length - this.size > 32) {
            Object[] newArray = new Object[this.array.length - 16];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        }
    }

    public K remove(K key) {
        int pos = this.getPosition(key);
        if (pos != -1) {
            if (pos != this.size - 1) {
                System.arraycopy(this.array, pos + 1, this.array, pos, this.size - pos - 1);
                this.reduceArray();
            }
            --this.size;
            return key;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public List<K> getKeys() {
        ArrayList<K> list = new ArrayList<K>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list.add(this.array[i]);
        }
        return list;
    }

    public void printTree() {
        if (this.isEmpty()) {
            System.out.println("Tree is empty");
            return;
        }
        boolean isFirst = false;
        for (K key : this.array) {
            if (isFirst) {
                isFirst = false;
            } else {
                System.out.print(", ");
            }
            System.out.println(key);
        }
    }

    public K get(int position) throws ArrayIndexOutOfBoundsException {
        if (position < 0 || position >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[position];
    }

    public K getFirst() {
        if (this.size != 0) {
            return this.array[0];
        }
        return null;
    }

    public K getLast() {
        if (this.size != 0) {
            return this.array[this.size - 1];
        }
        return null;
    }

    public K findGreater(K key) {
        int res;
        if (key == null) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.comparator.compare(this.array[0], key) > 0) {
                    return this.array[0];
                }
                return null;
            }
            case 2: {
                if (this.comparator.compare(this.array[0], key) > 0) {
                    return this.array[0];
                }
                if (this.comparator.compare(this.array[1], key) > 0) {
                    return this.array[1];
                }
                return null;
            }
        }
        int current = this.size >> 1;
        int start = 0;
        int end = this.size - 1;
        while (end - start + 1 > 2) {
            res = this.comparator.compare(this.array[current], key);
            if (res == 0) {
                return this.array[current + 1];
            }
            if (res < 0) {
                start = current;
                current = current + end + 1 >> 1;
                continue;
            }
            end = current;
            current = current + start + 1 >> 1;
        }
        switch (end - start + 1) {
            case 1: {
                res = this.comparator.compare(this.array[start], key);
                if (res <= 0) {
                    if (start == this.size) {
                        return null;
                    }
                    return this.array[start + 1];
                }
                return this.array[start];
            }
            case 2: {
                res = this.comparator.compare(this.array[start], key);
                if (res <= 0) {
                    res = this.comparator.compare(this.array[start + 1], key);
                    if (res <= 0) {
                        if (start == this.size - 2) {
                            return null;
                        }
                        return this.array[start + 2];
                    }
                    return this.array[start + 1];
                }
                return this.array[start];
            }
        }
        return null;
    }

    public K findGreaterOrEqual(K key) {
        int res;
        if (key == null) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.comparator.compare(this.array[0], key) >= 0) {
                    return this.array[0];
                }
                return null;
            }
            case 2: {
                if (this.comparator.compare(this.array[0], key) >= 0) {
                    return this.array[0];
                }
                if (this.comparator.compare(this.array[1], key) >= 0) {
                    return this.array[1];
                }
                return null;
            }
        }
        int current = this.size >> 1;
        int start = 0;
        int end = this.size - 1;
        while (end - start + 1 > 2) {
            res = this.comparator.compare(this.array[current], key);
            if (res == 0) {
                return this.array[current];
            }
            if (res < 0) {
                start = current;
                current = current + end + 1 >> 1;
                continue;
            }
            end = current;
            current = current + start + 1 >> 1;
        }
        switch (end - start + 1) {
            case 1: {
                res = this.comparator.compare(this.array[start], key);
                if (res >= 0) {
                    return this.array[start];
                }
                if (start == this.size - 1) {
                    return null;
                }
                return this.array[start + 1];
            }
            case 2: {
                res = this.comparator.compare(this.array[start], key);
                if (res < 0) {
                    res = this.comparator.compare(this.array[start + 1], key);
                    if (res < 0) {
                        if (start == this.size - 2) {
                            return null;
                        }
                        return this.array[start + 2];
                    }
                    return this.array[start + 1];
                }
                return this.array[start];
            }
        }
        return null;
    }

    public K findLess(K key) {
        int res;
        if (key == null) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.comparator.compare(this.array[0], key) >= 0) {
                    return null;
                }
                return this.array[0];
            }
            case 2: {
                if (this.comparator.compare(this.array[0], key) >= 0) {
                    return null;
                }
                if (this.comparator.compare(this.array[1], key) >= 0) {
                    return this.array[0];
                }
                return this.array[1];
            }
        }
        int current = this.size >> 1;
        int start = 0;
        int end = this.size - 1;
        while (end - start + 1 > 2) {
            res = this.comparator.compare(this.array[current], key);
            if (res == 0) {
                return this.array[current - 1];
            }
            if (res < 0) {
                start = current;
                current = current + end + 1 >> 1;
                continue;
            }
            end = current;
            current = current + start + 1 >> 1;
        }
        switch (end - start + 1) {
            case 1: {
                res = this.comparator.compare(this.array[start], key);
                if (res >= 0) {
                    if (start == 1) {
                        return null;
                    }
                    return this.array[start - 1];
                }
                return this.array[start];
            }
            case 2: {
                res = this.comparator.compare(this.array[start], key);
                if (res >= 0) {
                    if (start == 0) {
                        return null;
                    }
                    return this.array[start - 1];
                }
                if (this.comparator.compare(this.array[start + 1], key) >= 0) {
                    return this.array[start];
                }
                return this.array[start + 1];
            }
        }
        return null;
    }

    public K findLessOrEqual(K key) {
        int res;
        if (key == null) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.comparator.compare(this.array[0], key) <= 0) {
                    return this.array[0];
                }
                return null;
            }
            case 2: {
                int res2 = this.comparator.compare(this.array[0], key);
                if (res2 > 0) {
                    return null;
                }
                if (res2 == 0) {
                    return this.array[0];
                }
                res2 = this.comparator.compare(this.array[1], key);
                if (res2 == 0) {
                    return this.array[1];
                }
                if (this.comparator.compare(this.array[1], key) > 0) {
                    return this.array[0];
                }
                return this.array[1];
            }
        }
        int current = this.size >> 1;
        int start = 0;
        int end = this.size - 1;
        while (end - start + 1 > 2) {
            res = this.comparator.compare(this.array[current], key);
            if (res == 0) {
                return this.array[current];
            }
            if (res < 0) {
                start = current;
                current = current + end + 1 >> 1;
                continue;
            }
            end = current;
            current = current + start + 1 >> 1;
        }
        switch (end - start + 1) {
            case 1: {
                res = this.comparator.compare(this.array[start], key);
                if (res > 0) {
                    if (start == 1) {
                        return null;
                    }
                    return this.array[start - 1];
                }
                return this.array[start];
            }
            case 2: {
                res = this.comparator.compare(this.array[start], key);
                if (res > 0) {
                    if (start == 0) {
                        return null;
                    }
                    return this.array[start - 1];
                }
                res = this.comparator.compare(this.array[start + 1], key);
                if (res > 0) {
                    return this.array[start];
                }
                return this.array[start + 1];
            }
        }
        return null;
    }

    public K find(K key) {
        if (key == null) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.comparator.compare(this.array[0], key) == 0) {
                    return this.array[0];
                }
                return null;
            }
            case 2: {
                if (this.comparator.compare(this.array[0], key) == 0) {
                    return this.array[0];
                }
                if (this.comparator.compare(this.array[1], key) == 0) {
                    return this.array[1];
                }
                return null;
            }
        }
        int current = this.size >> 1;
        int start = 0;
        int end = this.size - 1;
        while (end - start + 1 > 2) {
            int res = this.comparator.compare(this.array[current], key);
            if (res == 0) {
                return this.array[current];
            }
            if (res < 0) {
                start = current;
                current = current + end + 1 >> 1;
                continue;
            }
            end = current;
            current = current + start + 1 >> 1;
        }
        switch (end - start + 1) {
            case 1: {
                if (this.comparator.compare(this.array[start], key) == 0) {
                    return this.array[start];
                }
                return null;
            }
            case 2: {
                if (this.comparator.compare(this.array[start], key) == 0) {
                    return this.array[start];
                }
                if (this.comparator.compare(this.array[end], key) == 0) {
                    return this.array[end];
                }
                return null;
            }
        }
        return null;
    }

    public int getPosition(K key) {
        if (key == null) {
            return -1;
        }
        switch (this.size) {
            case 0: {
                return -1;
            }
            case 1: {
                if (this.comparator.compare(this.array[0], key) == 0) {
                    return 0;
                }
                return -1;
            }
            case 2: {
                if (this.comparator.compare(this.array[0], key) == 0) {
                    return 0;
                }
                if (this.comparator.compare(this.array[1], key) == 0) {
                    return 1;
                }
                return -1;
            }
        }
        int current = this.size >> 1;
        int start = 0;
        int end = this.size - 1;
        while (end - start + 1 > 2) {
            int res = this.comparator.compare(this.array[current], key);
            if (res == 0) {
                return current;
            }
            if (res < 0) {
                start = current;
                current = current + end + 1 >> 1;
                continue;
            }
            end = current;
            current = current + start + 1 >> 1;
        }
        switch (end - start + 1) {
            case 1: {
                if (this.comparator.compare(this.array[start], key) == 0) {
                    return start;
                }
                return -1;
            }
            case 2: {
                if (this.comparator.compare(this.array[start], key) == 0) {
                    return start;
                }
                if (this.comparator.compare(this.array[end], key) == 0) {
                    return end;
                }
                return -1;
            }
        }
        return -1;
    }

    public int getAfterPosition(K key) {
        if (key == null) {
            return -1;
        }
        switch (this.size) {
            case 0: {
                return -1;
            }
            case 1: {
                if (this.comparator.compare(this.array[0], key) > 0) {
                    return 0;
                }
                return -1;
            }
            case 2: {
                if (this.comparator.compare(this.array[0], key) > 0) {
                    return 0;
                }
                if (this.comparator.compare(this.array[1], key) > 0) {
                    return 1;
                }
                return -1;
            }
        }
        int current = this.size >> 1;
        int start = 0;
        int end = this.size - 1;
        while (end - start + 1 > 2) {
            int res = this.comparator.compare(this.array[current], key);
            if (res == 0) {
                if (current != this.size - 1) {
                    return current + 1;
                }
                return -1;
            }
            if (res < 0) {
                start = current;
                current = current + end + 1 >> 1;
                continue;
            }
            end = current;
            current = current + start + 1 >> 1;
        }
        switch (end - start + 1) {
            case 1: {
                if (this.comparator.compare(this.array[start], key) > 0) {
                    return start;
                }
                return -1;
            }
            case 2: {
                if (this.comparator.compare(this.array[start], key) > 0) {
                    return start;
                }
                if (this.comparator.compare(this.array[end], key) > 0) {
                    return end;
                }
                return -1;
            }
        }
        return -1;
    }

    public int getBeforePosition(K key) {
        if (key == null) {
            return -1;
        }
        switch (this.size) {
            case 0: {
                return -1;
            }
            case 1: {
                if (this.comparator.compare(this.array[0], key) < 0) {
                    return 0;
                }
                return -1;
            }
            case 2: {
                if (this.comparator.compare(this.array[1], key) < 0) {
                    return 1;
                }
                if (this.comparator.compare(this.array[0], key) < 0) {
                    return 0;
                }
                return -1;
            }
        }
        int current = this.size >> 1;
        int start = 0;
        int end = this.size - 1;
        while (end - start + 1 > 2) {
            int res = this.comparator.compare(this.array[current], key);
            if (res == 0) {
                if (current == 0) {
                    return -1;
                }
                return current - 1;
            }
            if (res < 0) {
                start = current;
                current = current + end + 1 >> 1;
                continue;
            }
            end = current;
            current = current + start + 1 >> 1;
        }
        switch (end - start + 1) {
            case 1: {
                if (this.comparator.compare(this.array[start], key) < 0) {
                    return start;
                }
                return -1;
            }
            case 2: {
                if (this.comparator.compare(this.array[end], key) < 0) {
                    return end;
                }
                if (this.comparator.compare(this.array[start], key) < 0) {
                    return start;
                }
                return -1;
            }
        }
        return -1;
    }

    public boolean contains(K key) {
        return this.find(key) != null;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int i = 0; i < this.size; ++i) {
            K key = this.array[i];
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(key);
        }
        return sb.toString();
    }
}

