/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.pagedSearch;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsContainer;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsStates;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PagedResultsGrammar
extends AbstractGrammar<PagedResultsContainer> {
    static final Logger LOG = LoggerFactory.getLogger(PagedResultsGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<?> instance = new PagedResultsGrammar();

    private PagedResultsGrammar() {
        this.setName(PagedResultsGrammar.class.getName());
        this.transitions = new GrammarTransition[PagedResultsStates.LAST_PAGED_SEARCH_STATE.ordinal()][256];
        this.transitions[PagedResultsStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(PagedResultsStates.START_STATE, PagedResultsStates.PAGED_SEARCH_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[PagedResultsStates.PAGED_SEARCH_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<PagedResultsContainer>(PagedResultsStates.PAGED_SEARCH_SEQUENCE_STATE, PagedResultsStates.SIZE_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction<PagedResultsContainer>("Set PagedSearchControl size"){

            @Override
            public void action(PagedResultsContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int size = IntegerDecoder.parse(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    if (size < 0) {
                        size = Integer.MAX_VALUE;
                    }
                    if (IS_DEBUG) {
                        LOG.debug("size = " + size);
                    }
                    container.getDecorator().setSize(size);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_04050, new Object[0]);
                    LOG.error(msg, (Throwable)ide);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[PagedResultsStates.SIZE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<PagedResultsContainer>(PagedResultsStates.SIZE_STATE, PagedResultsStates.COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<PagedResultsContainer>("Set PagedSearchControl cookie"){

            @Override
            public void action(PagedResultsContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                if (container.getCurrentTLV().getLength() == 0) {
                    container.getDecorator().setCookie(Strings.EMPTY_BYTES);
                } else {
                    container.getDecorator().setCookie(value.getData());
                }
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

