/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.validator.WSDLValidator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLValidatorMojo
extends AbstractMojo {
    private Boolean verbose;
    private Boolean quiet;
    private File wsdlRoot;
    private File testWsdlRoot;
    private File markerDirectory;
    private String[] includes;
    private String[] excludes;

    private String getIncludeExcludeString(String[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        if (arr != null) {
            for (String s : arr) {
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(s);
            }
        }
        return str.toString();
    }

    private List<File> getWsdlFiles(File dir) throws MojoExecutionException {
        ArrayList<String> exList = new ArrayList<String>();
        if (this.excludes != null) {
            exList.addAll(Arrays.asList(this.excludes));
        }
        exList.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        String inc = this.getIncludeExcludeString(this.includes);
        String ex = this.getIncludeExcludeString(exList.toArray(new String[exList.size()]));
        try {
            List newfiles = FileUtils.getFiles((File)dir, (String)inc, (String)ex);
            return CastUtils.cast((List)newfiles);
        }
        catch (IOException exc) {
            throw new MojoExecutionException(exc.getMessage(), (Exception)exc);
        }
    }

    private void processWsdl(File file) throws MojoExecutionException {
        File doneFile = new File(this.markerDirectory, "." + file.getName().replace('?', '_').replace('&', '_') + ".DONE");
        boolean doWork = false;
        if (!doneFile.exists()) {
            doWork = true;
        } else if (file.lastModified() > doneFile.lastModified()) {
            doWork = true;
        }
        if (doWork) {
            doneFile.delete();
            ArrayList<String> list = new ArrayList<String>();
            if (this.verbose != null && this.verbose.booleanValue()) {
                list.add("-verbose");
            }
            if (this.quiet != null && this.quiet.booleanValue()) {
                list.add("-quiet");
            }
            this.getLog().debug((CharSequence)("Calling wsdlvalidator with args: " + list));
            try {
                list.add(file.getCanonicalPath());
                String[] pargs = list.toArray(new String[list.size()]);
                InputStream toolspecStream = WSDLValidator.class.getResourceAsStream("wsdlvalidator.xml");
                ToolSpec spec = new ToolSpec(toolspecStream, false);
                toolspecStream.close();
                WSDLValidator validator = new WSDLValidator(spec);
                validator.setArguments(pargs);
                boolean ok = validator.executeForMaven();
                if (!ok) {
                    throw new MojoExecutionException("WSDL failed validation: " + file.getName());
                }
                doneFile.createNewFile();
            }
            catch (Throwable e) {
                throw new MojoExecutionException(file.getName() + ": " + e.getMessage(), e);
            }
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.includes == null) {
            this.includes = new String[]{"*.wsdl"};
        }
        this.markerDirectory.mkdirs();
        ArrayList<File> wsdls = new ArrayList<File>();
        if (this.wsdlRoot != null && this.wsdlRoot.exists()) {
            wsdls.addAll(this.getWsdlFiles(this.wsdlRoot));
        }
        if (this.testWsdlRoot != null && this.testWsdlRoot.exists()) {
            wsdls.addAll(this.getWsdlFiles(this.testWsdlRoot));
        }
        for (File wsdl : wsdls) {
            this.processWsdl(wsdl);
        }
    }
}

