/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContext;

public final class AuthorizationUtils {
    private AuthorizationUtils() {
    }

    public static String[] getBasicAuthParts(String data) {
        String authDecoded = null;
        try {
            authDecoded = new String(Base64Utility.decode(data));
        }
        catch (Exception ex) {
            throw new NotAuthorizedException((Object)ex, new Object[0]);
        }
        String[] authInfo = authDecoded.split(":");
        if (authInfo.length == 2) {
            return authInfo;
        }
        throw new NotAuthorizedException(Response.status((int)401).build());
    }

    public static String[] getAuthorizationParts(MessageContext mc) {
        return AuthorizationUtils.getAuthorizationParts(mc, Collections.singleton("Basic"));
    }

    public static String[] getAuthorizationParts(MessageContext mc, Set<String> challenges) {
        String[] parts;
        List headers = mc.getHttpHeaders().getRequestHeader("Authorization");
        if (headers.size() == 1 && (parts = ((String)headers.get(0)).split(" ")).length == 2) {
            return parts;
        }
        AuthorizationUtils.throwAuthorizationFailure(challenges);
        return null;
    }

    public static void throwAuthorizationFailure(Set<String> challenges) {
        AuthorizationUtils.throwAuthorizationFailure(challenges, null);
    }

    public static void throwAuthorizationFailure(Set<String> challenges, String realm) {
        Response.ResponseBuilder rb = Response.status((int)401);
        StringBuilder sb = new StringBuilder();
        for (String challenge : challenges) {
            if ("*".equals(challenge)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(challenge);
        }
        if (sb.length() > 0) {
            if (realm != null) {
                sb.append(" realm=\"" + realm + "\"");
            }
            rb.header("WWW-Authenticate", (Object)sb.toString());
        }
        Response r = rb.build();
        throw new NotAuthorizedException(r);
    }
}

