/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import org.apache.cxf.Bus;
import org.apache.cxf.annotations.EvaluateAllEndpoints;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ConduitSelectorHolder;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;

@NoJSR250Annotations
@EvaluateAllEndpoints
public class FailoverFeature
extends AbstractFeature {
    private FailoverStrategy failoverStrategy;
    private FailoverTargetSelector targetSelector;

    @Override
    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        if (provider instanceof ConduitSelectorHolder) {
            ConduitSelectorHolder csHolder = (ConduitSelectorHolder)((Object)provider);
            Endpoint endpoint = csHolder.getConduitSelector().getEndpoint();
            ConduitSelector conduitSelector = this.initTargetSelector(endpoint);
            csHolder.setConduitSelector(conduitSelector);
        }
    }

    @Override
    public void initialize(Client client, Bus bus) {
        ConduitSelector selector = this.initTargetSelector(client.getConduitSelector().getEndpoint());
        client.setConduitSelector(selector);
    }

    protected ConduitSelector initTargetSelector(Endpoint endpoint) {
        FailoverTargetSelector selector = this.getTargetSelector();
        selector.setEndpoint(endpoint);
        if (this.getStrategy() != null) {
            selector.setStrategy(this.getStrategy());
        }
        return selector;
    }

    public FailoverTargetSelector getTargetSelector() {
        if (this.targetSelector == null) {
            this.targetSelector = new FailoverTargetSelector();
        }
        return this.targetSelector;
    }

    public void setTargetSelector(FailoverTargetSelector selector) {
        this.targetSelector = selector;
    }

    public void setStrategy(FailoverStrategy strategy) {
        this.failoverStrategy = strategy;
    }

    public FailoverStrategy getStrategy() {
        return this.failoverStrategy;
    }
}

